/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.jooq;

import io.horizon.uca.cache.Cc;
import io.vertx.tp.atom.modeling.data.DataEvent;
import io.vertx.tp.atom.refine.Ao;
import io.vertx.tp.modular.jooq.JQAggregate;
import io.vertx.tp.modular.jooq.JQDelete;
import io.vertx.tp.modular.jooq.JQInsert;
import io.vertx.tp.modular.jooq.JQQuery;
import io.vertx.tp.modular.jooq.JQRead;
import io.vertx.tp.modular.jooq.JQUpdate;
import io.vertx.tp.modular.metadata.AoSentence;
import org.jooq.DSLContext;

public class JQEngine {
    private static final Cc<String, JQEngine> CC_ENGINE = Cc.openThread();
    private final transient JQInsert insertT;
    private final transient JQDelete deleteT;
    private final transient JQQuery queryT;
    private final transient JQUpdate updateT;
    private final transient JQAggregate aggrT;
    private final transient JQRead readT;

    private JQEngine(DSLContext context) {
        boolean isSql = Ao.isDebug();
        if (isSql) {
            context.settings().setDebugInfoOnStackTrace(Boolean.TRUE);
        }
        this.insertT = new JQInsert(context);
        this.deleteT = new JQDelete(context);
        this.updateT = new JQUpdate(context);
        this.readT = new JQRead(context);
        this.aggrT = new JQAggregate(context);
        this.queryT = new JQQuery(context);
    }

    public static JQEngine create(DSLContext context) {
        return (JQEngine)CC_ENGINE.pick(() -> new JQEngine(context), (Object)String.valueOf(context.hashCode()));
    }

    public JQEngine bind(AoSentence sentence) {
        this.queryT.bind(sentence);
        return this;
    }

    public DataEvent update(DataEvent event) {
        return this.updateT.update(event);
    }

    public DataEvent updateBatch(DataEvent event) {
        return this.updateT.updateBatch(event);
    }

    public DataEvent insert(DataEvent event) {
        return this.insertT.insert(event);
    }

    public DataEvent insertBatch(DataEvent events) {
        return this.insertT.insertBatch(events);
    }

    public DataEvent fetchByIds(DataEvent events) {
        return this.readT.fetchByIds(events);
    }

    public DataEvent fetchById(DataEvent event) {
        return this.readT.fetchById(event);
    }

    public DataEvent fetchOne(DataEvent event) {
        return this.queryT.fetchOne(event);
    }

    public DataEvent fetchAll(DataEvent event) {
        return this.queryT.fetchAll(event);
    }

    public DataEvent search(DataEvent event) {
        return this.queryT.search(event);
    }

    public DataEvent query(DataEvent event) {
        return this.queryT.query(event);
    }

    public DataEvent delete(DataEvent event) {
        return this.deleteT.delete(event);
    }

    public DataEvent deleteBatch(DataEvent event) {
        return this.deleteT.deleteBatch(event);
    }

    public DataEvent count(DataEvent event) {
        return this.aggrT.count(event);
    }
}

