/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.metadata;

import cn.vertxup.atom.domain.tables.pojos.MField;
import io.horizon.uca.log.Annal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.atom.cv.em.CheckResult;
import io.vertx.tp.atom.cv.sql.SqlStatement;
import io.vertx.tp.atom.modeling.Schema;
import io.vertx.tp.modular.jdbc.AoConnection;
import io.vertx.tp.modular.metadata.AoBuilder;
import io.vertx.tp.modular.metadata.AoReflector;
import io.vertx.tp.modular.metadata.AoSentence;
import io.vertx.tp.modular.metadata.AoVerifier;
import io.vertx.tp.modular.metadata.CommonVerifier;
import io.vertx.tp.modular.sql.SqlDDLBuilder;
import io.vertx.tp.modular.sql.SqlDDLProvider;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractBuilder
implements AoBuilder,
SqlStatement {
    protected final transient AoConnection conn;
    private final transient SqlDDLBuilder builder = SqlDDLBuilder.create();
    private final transient SqlDDLProvider provider = SqlDDLProvider.create();

    public AbstractBuilder(AoConnection conn) {
        this.conn = conn;
    }

    public abstract AoSentence getSentence();

    public abstract AoReflector getReflector();

    public AoVerifier getVerifier() {
        return new CommonVerifier(this.conn, this.getSentence());
    }

    @Override
    public boolean synchron(Schema schema) {
        String sql;
        String tableName = schema.getTable();
        boolean exist = this.getVerifier().verifyTable(tableName);
        this.getLogger().info("[ Ox ] \u68c0\u67e5\u8868\u4fe1\u606f table = {0}\uff0c\u662f\u5426\u5b58\u5728\uff1fexist = {1}", new Object[]{tableName, exist});
        ArrayList<String> lines = new ArrayList<String>();
        if (exist) {
            lines.addAll(this.provider.on(this.getSentence()).on(this.getReflector()).prepareAlterLines(schema));
            sql = Ut.fromJoin(lines, (String)"");
        } else {
            Set<String> fields = schema.getFieldNames();
            if (0 == fields.size()) {
                return Boolean.TRUE;
            }
            lines.addAll(this.provider.on(this.getSentence()).prepareCreateLines(schema));
            sql = this.builder.buildCreateTable(schema.getTable(), lines);
        }
        String[] segments = sql.split(";");
        this.getLogger().info("[ Ox ] sql: {0}", new Object[]{sql});
        int respCode = 0;
        for (String segment : segments) {
            if (!Ut.isNotNil((String)segment)) continue;
            respCode = this.conn.execute(segment);
        }
        return 0 == respCode;
    }

    @Override
    public boolean purge(Schema schema) {
        return false;
    }

    @Override
    public boolean purge(String tableName) {
        return false;
    }

    @Override
    public JsonObject report(Schema schema) {
        String table = schema.getTable();
        AoReflector reflector = this.getReflector();
        AoSentence sentence = this.getSentence();
        JsonObject resultObj = new JsonObject();
        JsonArray resultList = new JsonArray();
        List<ConcurrentMap<String, Object>> columnDetailList = reflector.getColumnDetail(table);
        schema.getColumnNames().forEach(column -> {
            MField field = schema.getFieldByColumn((String)column);
            ConcurrentMap<String, Object> columnDetail = reflector.getColumnDetails((String)column, columnDetailList);
            CheckResult checkResult = sentence.checkFieldType(field, columnDetail);
            JsonObject fieldResult = new JsonObject().put("same", (Object)(checkResult == CheckResult.SKIP ? 1 : 0)).put("name", (Object)field.getName()).put("columnName", (Object)field.getColumnName()).put("type", (Object)sentence.columnType(field).toUpperCase()).put("oldType", (Object)columnDetail.get(reflector.getDataTypeWord()).toString().toUpperCase()).put("length", (Object)(null != field.getLength() ? field.getLength() : 0)).put("oldLength", (Object)(columnDetail.get(reflector.getLengthWord()).toString().equalsIgnoreCase("NULL") ? "0" : columnDetail.get(reflector.getLengthWord()).toString()));
            resultList.add((Object)fieldResult);
        });
        return resultObj.put("identifier", (Object)schema.getEntity().getIdentifier()).put("details", (Object)resultList);
    }

    @Override
    public boolean rename(String tableName) {
        boolean exist = this.getVerifier().verifyTable(tableName);
        this.getLogger().info("[ Ox ] \u68c0\u67e5\u8868\u4fe1\u606f table = {0}\uff0c\u662f\u5426\u5b58\u5728\uff1fexist = {1}", new Object[]{tableName, exist});
        if (!exist) {
            return Boolean.TRUE;
        }
        String sql = this.builder.buildRenameTable(tableName);
        this.getLogger().info("[ Ox ] sql: {0}", new Object[]{sql});
        int respCode = 0;
        if (Ut.isNotNil((String)sql)) {
            respCode = this.conn.execute(sql);
        }
        return 0 == respCode;
    }

    @Override
    public boolean purge(Set<String> tableNames) {
        return false;
    }

    private Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

