/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.modular.plugin;

import io.horizon.uca.cache.Cc;
import io.modello.specification.HRecord;
import io.vertx.core.Future;
import io.vertx.tp.atom.modeling.element.DataTpl;
import io.vertx.tp.modular.plugin.IoArranger;
import io.vertx.tp.modular.plugin.IoHub;
import io.vertx.tp.modular.reference.AoRay;
import io.vertx.tp.modular.reference.RayBatch;
import io.vertx.tp.modular.reference.RaySingle;
import java.util.Objects;

public class IoNerve
implements IoHub {
    private static final Cc<String, AoRay<HRecord>> CC_RAY = Cc.open();
    private static final Cc<String, AoRay<HRecord>> CC_RAY_ASYNC = Cc.open();
    private static final Cc<String, AoRay<HRecord[]>> CC_RAY_BATCH = Cc.open();
    private static final Cc<String, AoRay<HRecord[]>> CC_RAY_BATCH_ASYNC = Cc.open();

    @Override
    public HRecord in(HRecord record, DataTpl tpl) {
        IoArranger.runIn(record, IoArranger.pluginInBefore(tpl));
        IoArranger.runIn(record, IoArranger.pluginIn(tpl));
        IoArranger.runNorm(record, IoArranger.pluginNormalize(tpl));
        IoArranger.runIn(record, IoArranger.pluginInAfter(tpl));
        return record;
    }

    @Override
    public HRecord[] in(HRecord[] records, DataTpl tpl) {
        IoArranger.runIn(records, IoArranger.pluginInBefore(tpl));
        IoArranger.runIn(records, IoArranger.pluginIn(tpl));
        IoArranger.runNorm(records, IoArranger.pluginNormalize(tpl));
        IoArranger.runIn(records, IoArranger.pluginInAfter(tpl));
        return records;
    }

    @Override
    public HRecord out(HRecord record, DataTpl tpl) {
        if (Objects.isNull(record)) {
            return null;
        }
        this.runOut(record, tpl);
        AoRay ray = (AoRay)CC_RAY.pick(() -> new RaySingle().on(tpl), (Object)tpl.identifier());
        return ray.doRay(record);
    }

    @Override
    public HRecord[] out(HRecord[] records, DataTpl tpl) {
        this.runOut(records, tpl);
        AoRay ray = (AoRay)CC_RAY_BATCH.pick(() -> new RayBatch().on(tpl), (Object)tpl.identifier());
        return ray.doRay(records);
    }

    @Override
    public Future<HRecord> outAsync(HRecord record, DataTpl tpl) {
        if (Objects.isNull(record)) {
            return null;
        }
        this.runOut(record, tpl);
        AoRay ray = (AoRay)CC_RAY_ASYNC.pick(() -> new RaySingle().on(tpl), (Object)tpl.identifier());
        return ray.doRayAsync(record);
    }

    @Override
    public Future<HRecord[]> outAsync(HRecord[] records, DataTpl tpl) {
        this.runOut(records, tpl);
        AoRay ray = (AoRay)CC_RAY_BATCH_ASYNC.pick(() -> new RayBatch().on(tpl), (Object)tpl.identifier());
        return ray.doRayAsync(records);
    }

    private void runOut(HRecord record, DataTpl tpl) {
        IoArranger.runOut(record, IoArranger.pluginOutBefore(tpl));
        IoArranger.runOut(record, IoArranger.pluginOut(tpl));
        IoArranger.runExpr(record, IoArranger.pluginExpression(tpl));
        IoArranger.runOut(record, IoArranger.pluginOutAfter(tpl));
    }

    private void runOut(HRecord[] records, DataTpl tpl) {
        IoArranger.runOut(records, IoArranger.pluginOutBefore(tpl));
        IoArranger.runOut(records, IoArranger.pluginOut(tpl));
        IoArranger.runExpr(records, IoArranger.pluginExpression(tpl));
        IoArranger.runOut(records, IoArranger.pluginOutAfter(tpl));
    }
}

