/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.atom;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.tp.crud.atom.IxConfig;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._404ModuleMissingException;
import io.vertx.up.aiki.Ux;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import java.util.function.BiFunction;

public class IxMeta {
    private final transient Class<?> target;
    private transient IxConfig config;
    private transient UxJooq jooq;
    private transient WebException ex;

    private IxMeta(Class<?> clazz) {
        this.target = clazz;
    }

    public static IxMeta create(Class<?> clazz) {
        return new IxMeta(clazz);
    }

    private void initDao(String actor) {
        try {
            this.config = IxPin.getActor(actor);
            this.jooq = IxPin.getDao(this.config);
            if (null == this.jooq) {
                this.ex = new _404ModuleMissingException(this.target, actor);
            }
        }
        catch (WebException error) {
            this.ex = error;
        }
    }

    private void logRequest(Envelop envelop) {
        HttpMethod method = envelop.getMethod();
        String uri = envelop.getUri();
        Annal logger = Annal.get(this.target);
        Ix.infoRest(logger, "---> Uri Addr: {0} {1}", method, uri);
    }

    public IxMeta input(Envelop envelop) {
        String actor = Ux.getString((Envelop)envelop);
        this.initDao(actor);
        this.logRequest(envelop);
        return this;
    }

    public Future<Envelop> envelop(BiFunction<UxJooq, IxConfig, Future<Envelop>> actuator) {
        WebException error = this.ex;
        if (null == error) {
            try {
                return actuator.apply(this.jooq, this.config);
            }
            catch (WebException ex) {
                return Future.failedFuture((Throwable)ex);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return Future.failedFuture((Throwable)ex);
            }
        }
        return Future.failedFuture((Throwable)error);
    }
}

