/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxConfig;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.aiki.Ux;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.log.Annal;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxDao {
    private static final Annal LOGGER = Annal.get(IxDao.class);
    private static final ConcurrentMap<String, IxConfig> CONFIG_MAP = new ConcurrentHashMap<String, IxConfig>();

    IxDao() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/module/", (String)"json");
        files.forEach(file -> {
            String path = "plugin/crud/module/" + file;
            JsonObject configDao = Ut.ioJObject((String)path);
            Fn.safeNull(() -> {
                IxConfig config = (IxConfig)Ut.deserialize((JsonObject)configDao, IxConfig.class);
                String key = file.replace(".json", "");
                Ix.infoInit(LOGGER, "--- file = {0}, key = {1}", path, key);
                CONFIG_MAP.put(key, config);
            }, (Object[])new Object[]{configDao});
        });
        Ix.infoInit(LOGGER, "IxDao Finished ! Size = {0}", CONFIG_MAP.size());
    }

    static IxConfig get(String actor) {
        Ix.infoRest(LOGGER, "Actor = {0}", actor);
        IxConfig config = (IxConfig)CONFIG_MAP.get(actor);
        return (IxConfig)Fn.getNull(null, () -> config, (Object[])new Object[]{config});
    }

    static UxJooq get(IxConfig config) {
        return (UxJooq)Fn.getNull(null, () -> {
            Class<?> daoCls = config.getDaoCls();
            assert (null != daoCls) : " Should not be null, check configuration";
            UxJooq dao = Ux.Jooq.on(daoCls);
            String pojo = config.getPojo();
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao;
        }, (Object[])new Object[]{config});
    }
}

