/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.atom.Rule;
import io.vertx.up.log.Annal;
import io.zero.epic.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxValidator {
    private static final Annal LOGGER = Annal.get(IxValidator.class);
    private static final ConcurrentMap<String, ConcurrentMap<String, List<Rule>>> RULE_MAP = new ConcurrentHashMap<String, ConcurrentMap<String, List<Rule>>>();

    IxValidator() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/validator/", (String)"yml");
        files.forEach(file -> {
            String path = "plugin/crud/validator/" + file;
            JsonObject rules = (JsonObject)Ut.ioYaml((String)path);
            ConcurrentHashMap ruleMap = new ConcurrentHashMap();
            rules.fieldNames().forEach(field -> {
                JsonArray ruleArray = rules.getJsonArray(field);
                ruleMap.put(field, IxValidator.getRules(ruleArray));
            });
            String key = file.replace(".yml", "");
            Ix.infoInit(LOGGER, "--- file = {0}, key = {1}", path, key);
            RULE_MAP.put(key, ruleMap);
        });
        Ix.infoInit(LOGGER, "IxValidator Finished ! Size = {0}", RULE_MAP.size());
    }

    private static List<Rule> getRules(JsonArray ruleArray) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        Ut.itJArray((JsonArray)ruleArray, (item, index) -> {
            Rule rule = Rule.create((JsonObject)item);
            ruleList.add(rule);
        });
        return ruleList;
    }

    static ConcurrentMap<String, List<Rule>> getRules(String actor) {
        ConcurrentHashMap rules = (ConcurrentHashMap)RULE_MAP.get(actor);
        if (null == rules) {
            rules = new ConcurrentHashMap();
        }
        return rules;
    }
}

