/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxConfig;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.up.aiki.Ux;
import io.vertx.up.aiki.UxJooq;
import io.vertx.up.log.Annal;
import io.zero.epic.Ut;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Function;

class IxFn {
    private static final Annal LOGGER = Annal.get(IxFn.class);

    IxFn() {
    }

    static Function<UxJooq, Future<JsonObject>> search(JsonObject filters, IxConfig config) {
        String pojo = config.getPojo();
        return dao -> {
            IxLog.infoDao(LOGGER, "( Search ) Dao -> {0}, pojo = {1}", dao.getClass(), pojo);
            JsonObject criteria = new JsonObject();
            criteria.put("criteria", filters);
            if (Ut.notNil((String)pojo)) {
                return dao.searchAsync(criteria, pojo);
            }
            return dao.searchAsync(criteria);
        };
    }

    static Function<UxJooq, Future<JsonObject>> query(JsonObject criteria, IxConfig config) {
        String pojo = config.getPojo();
        return dao -> {
            IxLog.infoDao(LOGGER, "( Query ) Dao -> {0}, pojo = {1}", dao.getClass(), pojo);
            if (Ut.notNil((String)pojo)) {
                return dao.searchAsync(criteria, pojo);
            }
            return dao.searchAsync(criteria);
        };
    }

    static Function<UxJooq, Future<Boolean>> existing(JsonObject criteria, IxConfig config) {
        String pojo = config.getPojo();
        JsonObject parameters = new JsonObject();
        if (Ut.notNil((String)pojo)) {
            parameters.mergeIn(Ux.fromJson((JsonObject)criteria, (String)pojo));
        } else {
            parameters.mergeIn(criteria);
        }
        return dao -> {
            IxLog.infoDao(LOGGER, "( Query ) Dao -> {0}, pojo = {1}", dao.getClass(), pojo);
            return dao.existsOneAsync(parameters);
        };
    }

    static void audit(JsonObject auditor, JsonObject config, String userId) {
        if (Objects.nonNull(config) && Ut.notNil((String)userId)) {
            String at;
            String by = config.getString("by");
            if (Ut.notNil((String)by)) {
                auditor.put(by, userId);
            }
            if (Ut.notNil((String)(at = config.getString("at")))) {
                auditor.put(at, Instant.now());
            }
        }
    }
}

