/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.crud.atom.IxColumn;
import io.vertx.tp.crud.atom.IxConfig;
import io.vertx.tp.crud.atom.IxField;
import io.vertx.up.aiki.Ux;
import io.vertx.up.atom.Envelop;
import io.zero.epic.Ut;
import java.util.Objects;

class IxQuery {
    IxQuery() {
    }

    static JsonObject inKeys(JsonArray array, IxConfig config) {
        IxField field = config.getField();
        String keyField = field.getKey();
        JsonObject filters = new JsonObject();
        JsonArray keys = new JsonArray();
        array.stream().filter(Objects::nonNull).forEach(item -> {
            if (JsonObject.class == item.getClass()) {
                String keyValue = ((JsonObject)item).getString(keyField);
                if (Ut.notNil((String)keyValue)) {
                    keys.add(keyValue);
                }
            } else {
                keys.add(item);
            }
        });
        return filters.put(keyField + ",i", keys);
    }

    static JsonObject inColumns(Envelop envelop, IxConfig config) {
        String actor = Ux.getString((Envelop)envelop);
        IxColumn column = config.getColumn();
        JsonObject filters = new JsonObject();
        String actorField = column.getActor();
        if (Ut.notNil((String)actorField)) {
            filters.put(actorField, actor);
        }
        JsonObject data = IxQuery.input(envelop);
        JsonArray condition = column.getCondition();
        Ut.itJArray((JsonArray)condition, String.class, (columnField, index) -> {
            Object value = data.getValue(columnField);
            if (Objects.nonNull(value)) {
                filters.put(columnField, value);
            }
        });
        return filters;
    }

    private static JsonObject input(Envelop envelop) {
        JsonObject userData;
        JsonObject data = new JsonObject();
        User user = envelop.user();
        if (null != user && Objects.nonNull(userData = user.principal())) {
            data.mergeIn(userData);
        }
        MultiMap header = envelop.headers();
        header.forEach(entry -> data.put((String)entry.getKey(), (String)entry.getValue()));
        return data;
    }
}

