/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.actor;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.actor.AbstractActor;
import io.vertx.tp.crud.atom.IxField;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.business.ExSerial;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class SerialActor
extends AbstractActor {
    private static final Annal LOGGER = Annal.get(SerialActor.class);

    SerialActor() {
    }

    @Override
    public JsonObject proc(JsonObject data, IxModule config) {
        throw new RuntimeException("Do not support this method here.");
    }

    @Override
    public Future<JsonObject> procAsync(JsonObject data, IxModule config) {
        IxField field = config.getField();
        JsonObject numbers = field.getNumbers();
        if (Ut.isNil((JsonObject)numbers)) {
            return Ux.future((Object)data);
        }
        Ke.infoKe((Annal)LOGGER, (String)"Table here {0}, Serial numbers {0}", (Object[])new Object[]{config.getTable(), numbers.encodePrettily()});
        return Ke.channelAsync(ExSerial.class, () -> Ux.future((Object)data), serial -> {
            String sigma = data.getString("sigma");
            if (Ut.isNil((String)sigma)) {
                return Ux.future((Object)data);
            }
            ConcurrentHashMap numberMap = new ConcurrentHashMap();
            numbers.fieldNames().stream().filter(numberField -> !data.containsKey(numberField)).filter(numberField -> Objects.nonNull(numbers.getString(numberField))).forEach(numberField -> {
                String code = numbers.getString(numberField);
                numberMap.put(numberField, serial.serial(sigma, code));
            });
            return Ux.thenCombine(numberMap).compose(generated -> {
                Set generatedFields = generated.keySet();
                generatedFields.forEach(generatedField -> data.put(generatedField, (String)generated.get(generatedField)));
                return Ux.future((Object)data);
            });
        });
    }
}

