/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.connect;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxJoin;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.jq.UxJooq;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.BiFunction;

interface OxSwitcher {
    public static JsonObject getData(JsonObject original, IxModule module) {
        IxJoin connect = module.getConnect();
        JsonObject inputData = original.copy();
        String mapped = connect.getJoined(original);
        if (Ut.notNil((String)mapped)) {
            String joinedValue = original.getString(connect.getMappedBy());
            inputData.put(mapped, joinedValue);
        }
        return inputData;
    }

    public static JsonObject getCondition(JsonObject original, IxModule module) {
        JsonObject filters = new JsonObject();
        IxJoin connect = module.getConnect();
        String mapped = connect.getJoined(original);
        if (Ut.notNil((String)mapped)) {
            String joinedValue = original.getString(connect.getMappedBy());
            filters.put(mapped, joinedValue);
        }
        if (original.containsKey("sigma")) {
            filters.put("", Boolean.TRUE);
            filters.put("sigma", original.getString("sigma"));
        }
        return filters;
    }

    public static Future<Envelop> moveOn(JsonObject data, MultiMap headers, IxModule module, BiFunction<UxJooq, IxModule, Future<Envelop>> function) {
        IxJoin connect = module.getConnect();
        Annal LOGGER = Annal.get(OxSwitcher.class);
        if (Objects.isNull(connect)) {
            Ix.infoDao(LOGGER, "IxJoin is null", new Object[0]);
            return Ux.future((Object)Envelop.success((Object)data));
        }
        String moduleName = connect.getJoinedBy();
        if (Ut.isNil((String)moduleName)) {
            Ix.infoDao(LOGGER, "The `joinedBy` field is null", new Object[0]);
            return Ux.future((Object)Envelop.success((Object)data));
        }
        String identifier = data.getString(moduleName);
        IxModule config = connect.getModule(identifier);
        if (Objects.isNull(config)) {
            Ix.infoDao(LOGGER, "System could not find configuration for `{0}`, data = {1}", identifier, connect.getJoined());
            return Ux.future((Object)Envelop.success((Object)data));
        }
        UxJooq dao = IxPin.getDao(config, headers);
        return function.apply(dao, config);
    }

    public static Future<Envelop> moveEnd(JsonObject original, Envelop response, IxModule config) {
        JsonObject createdJoined = (JsonObject)response.data();
        if (Objects.isNull(createdJoined)) {
            createdJoined = new JsonObject();
        } else {
            String joinedField = config.getField().getKey();
            createdJoined.put("joinedKey", createdJoined.getString(joinedField));
        }
        createdJoined.mergeIn(original, true);
        return Ux.future((Object)Envelop.success((Object)createdJoined));
    }
}

