/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.cv.em.DsMode;
import io.vertx.tp.crud.init.IxConfiguration;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.DS;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.jq.UxJooq;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxDao {
    private static final Annal LOGGER = Annal.get(IxDao.class);
    private static final ConcurrentMap<String, IxModule> CONFIG_MAP = new ConcurrentHashMap<String, IxModule>();

    IxDao() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/module/", (String)"json");
        files.forEach(file -> {
            String path = "plugin/crud/module/" + file;
            JsonObject configDao = Ut.ioJObject((String)path);
            Fn.safeNull(() -> {
                IxModule config = (IxModule)Ut.deserialize((JsonObject)configDao, IxModule.class);
                String key = file.replace(".json", "");
                if (file.contains(config.getName())) {
                    Ix.infoInit(LOGGER, "--- file = {0}, key = {1}", path, key);
                    IxConfiguration.addUrs(key);
                    CONFIG_MAP.put(key, config);
                } else {
                    Ix.errorInit(LOGGER, " file = {0} will be ignored because the name ( name = `{1}` ) of definition does not match. ", path, config.getName());
                }
            }, (Object[])new Object[]{configDao});
        });
        Ix.infoInit(LOGGER, "IxDao Finished ! Size = {0}, Uris = {0}", CONFIG_MAP.size(), IxConfiguration.getUris().size());
    }

    static IxModule get(String actor) {
        Ix.debugRest(LOGGER, "Actor = {0}", actor);
        IxModule config = (IxModule)CONFIG_MAP.get(actor);
        return (IxModule)Fn.getNull(null, () -> config, (Object[])new Object[]{config});
    }

    static UxJooq get(IxModule config, MultiMap headers) {
        return (UxJooq)Fn.getNull(null, () -> {
            Class<?> daoCls = config.getDaoCls();
            assert (null != daoCls) : " Should not be null, check configuration";
            UxJooq dao = IxDao.get(config, daoCls, headers);
            String pojo = config.getPojo();
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao;
        }, (Object[])new Object[]{config});
    }

    private static UxJooq get(IxModule module, Class<?> clazz, MultiMap headers) {
        String modeKey;
        DsMode mode = module.getMode();
        UxJooq dao = DsMode.DYNAMIC == mode ? (UxJooq)Ke.channelSync(DS.class, () -> Ux.Jooq.on((Class)clazz), ds -> Ux.Jooq.on((Class)clazz, (DataPool)ds.switchDs(headers))) : (DsMode.HISTORY == mode ? Ux.Jooq.ons(clazz) : (DsMode.EXTENSION == mode ? (Ut.isNil((String)(modeKey = module.getModeKey())) ? Ux.Jooq.on(clazz) : Ux.Jooq.on(clazz, (String)modeKey)) : Ux.Jooq.on(clazz)));
        return dao;
    }
}

