/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.crud.api;

import cn.vertxup.crud.api.Unity;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.actor.IxActor;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._500ExportingErrorException;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxJooq;
import io.vertx.up.util.Ut;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

@Queue
public class FileActor {
    private static final Annal LOGGER = Annal.get(FileActor.class);
    @Plugin
    private transient ExcelClient client;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/IMPORT")
    public Future<Envelop> importFile(Envelop request) {
        String actor = Ux.getString((Envelop)request);
        String filename = Ux.getString1((Envelop)request);
        IxModule config = IxPin.getActor(actor);
        Future future = Future.future();
        File file = new File(filename);
        if (file.exists()) {
            Fn.safeJvm(() -> {
                FileInputStream inputStream = new FileInputStream(file);
                this.client.importTable(config.getTable(), (InputStream)inputStream, handler -> {
                    Ix.infoDao(LOGGER, "Successfully to finish loading ! data file = {0}", filename);
                    future.complete((Object)Envelop.success((Object)Boolean.TRUE));
                });
            });
        } else {
            future.complete((Object)Envelop.success((Object)Boolean.FALSE));
        }
        return future;
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/EXPORT")
    public Future<Envelop> exportFile(Envelop request) {
        ConcurrentHashMap exportedHeaders = new ConcurrentHashMap();
        JsonArray removed = new JsonArray();
        return Ix.create(this.getClass()).input(request).envelop((dao, config) -> Unity.fetchFull(dao, request, config).compose(columns -> {
            HashSet columnSet = new HashSet();
            Ut.itJArray((JsonArray)columns, (column, index) -> {
                String columnKey = column.getString(IxPin.getColumnKey());
                String columnLabel = column.getString(IxPin.getColumnLabel());
                if (Ut.notNil((String)columnKey) && Ut.notNil((String)columnLabel)) {
                    exportedHeaders.put(columnKey, columnLabel);
                    columnSet.add(columnKey);
                }
            });
            return Ux.toFuture(columnSet);
        }).compose(columnSet -> {
            JsonArray expected = Ux.getArray2((Envelop)request);
            columnSet.removeAll(expected.stream().filter(Objects::nonNull).map(column -> (String)column).collect(Collectors.toSet()));
            return Ux.toFuture((Object)Ut.toJArray((Set)columnSet));
        }).compose(projection -> {
            JsonObject body = Ux.getJson1((Envelop)request);
            body.put("projection", projection);
            removed.addAll(projection);
            return Ux.toFuture((Object)body);
        }).compose(input -> IxActor.verify().bind(request).procAsync((JsonObject)input, (IxModule)config)).compose(params -> Ix.query(params, config).apply((UxJooq)dao)).compose(data -> {
            JsonArray dataArray = data.getJsonArray("list");
            removed.stream().map(item -> (String)item).forEach(exportedHeaders::remove);
            return this.combineData(dataArray, exportedHeaders);
        }).compose(data -> {
            String actor = Ux.getString((Envelop)request);
            return this.exportTable(actor, (JsonArray)data);
        }).compose(buffer -> Envelop.success((Object)buffer).toFuture()));
    }

    private Future<JsonArray> combineData(JsonArray data, ConcurrentMap<String, String> headers) {
        JsonArray combined = new JsonArray();
        ArrayList columns = new ArrayList(headers.keySet());
        JsonArray header = new JsonArray();
        columns.forEach(column -> header.add((String)headers.get(column)));
        combined.add(header);
        Ut.itJArray((JsonArray)data, (each, index) -> {
            JsonArray row = new JsonArray();
            columns.stream().map(arg_0 -> ((JsonObject)each).getValue(arg_0)).forEach(arg_0 -> ((JsonArray)row).add(arg_0));
            combined.add(row);
        });
        return Ux.toFuture((Object)combined);
    }

    private Future<Buffer> exportTable(String identifier, JsonArray data) {
        Future future = Future.future();
        this.client.exportTable(identifier, data, handler -> {
            if (handler.succeeded()) {
                future.complete(handler.result());
            } else {
                Throwable error = handler.cause();
                if (Objects.nonNull(error)) {
                    _500ExportingErrorException failure = new _500ExportingErrorException(this.getClass(), error.getMessage());
                    future.fail((Throwable)((Object)failure));
                } else {
                    future.fail((Throwable)new _500InternalServerException(this.getClass(), "Unexpected Error"));
                }
            }
        });
        return future;
    }
}

