/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.actor;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.crud.actor.IxActor;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public abstract class AbstractActor
implements IxActor {
    private final transient JsonObject metadata = new JsonObject();
    private transient Envelop envelop;
    private transient String user;

    @Override
    public IxActor bind(Envelop envelop) {
        this.envelop = envelop;
        User user = envelop.user();
        if (Objects.nonNull(user)) {
            this.initLogged(user);
        }
        return this;
    }

    private void initLogged(User user) {
        JsonObject principle = user.principal();
        if (principle.containsKey("metadata")) {
            this.metadata.mergeIn(principle.getJsonObject("metadata"));
        }
        String token = principle.getString("jwt");
        JsonObject credential = Ux.Jwt.extract((String)token);
        this.user = credential.getString("user");
    }

    protected Envelop getRequest() {
        return this.envelop;
    }

    protected String getUser() {
        return this.user;
    }

    protected JsonObject getMetadata() {
        return this.metadata;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

