/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxConfiguration;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxJooq;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxDao {
    private static final Annal LOGGER = Annal.get(IxDao.class);
    private static final ConcurrentMap<String, IxModule> CONFIG_MAP = new ConcurrentHashMap<String, IxModule>();

    IxDao() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/module/", (String)"json");
        files.forEach(file -> {
            String path = "plugin/crud/module/" + file;
            JsonObject configDao = Ut.ioJObject((String)path);
            Fn.safeNull(() -> {
                IxModule config = (IxModule)Ut.deserialize((JsonObject)configDao, IxModule.class);
                String key = file.replace(".json", "");
                if (file.contains(config.getName())) {
                    Ix.infoInit(LOGGER, "--- file = {0}, key = {1}", path, key);
                    IxConfiguration.addUrs(key);
                    CONFIG_MAP.put(key, config);
                } else {
                    Ix.errorInit(LOGGER, " file = {0} will be ignored because the name ( name = `{1}` ) of definition does not match. ", path, config.getName());
                }
            }, (Object[])new Object[]{configDao});
        });
        Ix.infoInit(LOGGER, "IxDao Finished ! Size = {0}, Uris = {0}", CONFIG_MAP.size(), IxConfiguration.getUris().size());
    }

    static IxModule get(String actor) {
        Ix.infoRest(LOGGER, "Actor = {0}", actor);
        IxModule config = (IxModule)CONFIG_MAP.get(actor);
        return (IxModule)Fn.getNull(null, () -> config, (Object[])new Object[]{config});
    }

    static UxJooq get(IxModule config) {
        return (UxJooq)Fn.getNull(null, () -> {
            Class<?> daoCls = config.getDaoCls();
            assert (null != daoCls) : " Should not be null, check configuration";
            UxJooq dao = Ux.Jooq.on(daoCls);
            String pojo = config.getPojo();
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao;
        }, (Object[])new Object[]{config});
    }
}

