/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxMeta;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.refine.IxFn;
import io.vertx.tp.crud.refine.IxIs;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.crud.refine.IxQuery;
import io.vertx.tp.crud.refine.IxSerialize;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxJooq;
import java.util.List;
import java.util.function.Function;

public class Ix {
    public static boolean isExist(JsonObject result) {
        return IxIs.isExist(result);
    }

    public static void audit(JsonObject auditor, JsonObject config, String userId) {
        IxFn.audit(auditor, config, userId);
    }

    public static Function<UxJooq, Future<JsonObject>> search(JsonObject filters, IxModule config) {
        return IxFn.search(filters, config);
    }

    public static Function<UxJooq, Future<JsonObject>> query(JsonObject filters, IxModule config) {
        return IxFn.query(filters, config);
    }

    public static Function<UxJooq, Future<Boolean>> existing(JsonObject filters, IxModule config) {
        return IxFn.existing(filters, config);
    }

    public static IxMeta create(Class<?> clazz) {
        return IxMeta.create(clazz);
    }

    public static Future<JsonObject> unique(JsonObject result) {
        return Ux.toFuture((Object)IxSerialize.unique(result));
    }

    public static Future<JsonArray> list(JsonObject result) {
        return Ux.toFuture((Object)IxSerialize.list(result));
    }

    public static <T> Future<T> entityAsync(JsonObject data, IxModule config) {
        Object reference = IxSerialize.entity(data, config);
        return Ux.toFuture(reference);
    }

    public static <T> Future<List<T>> entityAsync(JsonArray data, IxModule config) {
        return Ux.toFuture(IxSerialize.entity(data, config));
    }

    public static Future<JsonArray> zipperAsync(JsonArray from, JsonArray to, IxModule config) {
        return Ux.toFuture((Object)IxSerialize.zipper(from, to, config));
    }

    public static Future<JsonObject> inKeys(JsonArray array, IxModule config) {
        return Ux.toFuture((Object)IxQuery.inKeys(array, config));
    }

    public static void infoInit(Annal logger, String pattern, Object ... args) {
        IxLog.infoInit(logger, pattern, args);
    }

    public static void infoRest(Annal logger, String pattern, Object ... args) {
        IxLog.infoRest(logger, pattern, args);
    }

    public static void infoFilters(Annal logger, String pattern, Object ... args) {
        IxLog.infoFilters(logger, pattern, args);
    }

    public static void infoVerify(Annal logger, String pattern, Object ... args) {
        IxLog.infoVerify(logger, pattern, args);
    }

    public static void infoDao(Annal logger, String pattern, Object ... args) {
        IxLog.infoDao(logger, pattern, args);
    }

    public static void errorInit(Annal logger, String pattern, Object ... args) {
        IxLog.errorInit(logger, pattern, args);
    }
}

