/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxField;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Uarr;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class IxSerialize {
    private static final Annal LOGGER = Annal.get(IxSerialize.class);

    IxSerialize() {
    }

    static JsonObject unique(JsonObject result) {
        JsonArray list = result.getJsonArray("list");
        return list.getJsonObject(0);
    }

    static JsonArray list(JsonObject result) {
        JsonArray list = result.getJsonArray("list");
        if (Objects.isNull(list)) {
            list = new JsonArray();
        }
        return list;
    }

    static JsonArray zipper(JsonArray from, JsonArray to, IxModule config) {
        IxField field = config.getField();
        String keyField = field.getKey();
        return Uarr.create((JsonArray)from).zip(to, keyField, keyField).to();
    }

    static <T> T entity(JsonObject data, IxModule config) {
        IxLog.infoDao(LOGGER, "Normalized: \n{0}", data.encodePrettily());
        String pojo = config.getPojo();
        Object reference = Ut.isNil((String)pojo) ? Ux.fromJson((JsonObject)data, config.getPojoCls()) : Ux.fromJson((JsonObject)data, config.getPojoCls(), (String)config.getPojo());
        IxLog.infoDao(LOGGER, "Deserialized: {0}", reference);
        return (T)reference;
    }

    static <T> List<T> entity(JsonArray data, IxModule config) {
        ArrayList list = new ArrayList();
        data.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(entity -> IxSerialize.entity(entity, config)).forEach(reference -> list.add(reference));
        return list;
    }
}

