/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.actor;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.actor.AbstractActor;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.atom.Rule;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.uca.rs.announce.Rigor;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;

class VerifyActor
extends AbstractActor {
    VerifyActor() {
    }

    @Override
    public JsonObject proc(JsonObject data, IxModule config) {
        Rigor rigor;
        WebException error;
        String key = this.getKey(data, config);
        Ix.infoVerify(this.getLogger(), "---> Rule: {0}", key);
        ConcurrentMap<String, List<Rule>> rules = IxPin.getRules(key);
        if (!rules.isEmpty() && null != (error = (rigor = Rigor.get(JsonObject.class)).verify(rules, (Object)data))) {
            Ix.infoVerify(this.getLogger(), "---> Error Code: {0}", String.valueOf(error.getCode()));
            throw error;
        }
        return data;
    }

    private String getKey(JsonObject data, IxModule config) {
        Envelop request = this.getRequest();
        String uri = request.uri();
        String method = request.method().name();
        String keyField = config.getField().getKey();
        String keyValue = data.getString(keyField);
        if (Ut.notNil((String)keyValue)) {
            uri = uri.replace(keyValue, "$" + keyField);
        }
        return uri.toLowerCase(Locale.getDefault()).replace('/', '.').substring(1) + "." + method.toLowerCase(Locale.getDefault());
    }
}

