/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.ke.atom.metadata.KField;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.atom.unity.Uarr;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class IxSerialize {
    private static final Annal LOGGER = Annal.get(IxSerialize.class);

    IxSerialize() {
    }

    static JsonObject serializePO(JsonObject result, IxModule config) {
        JsonArray list = result.getJsonArray("list");
        JsonObject queried = list.getJsonObject(0);
        return IxSerialize.serializeJ(queried, config);
    }

    static JsonArray serializePL(JsonObject result, IxModule config) {
        JsonArray list = result.getJsonArray("list");
        if (Objects.isNull(list)) {
            list = new JsonArray();
        }
        return IxSerialize.serializeA(list, config);
    }

    static JsonArray serializeA(JsonArray from, JsonArray to, IxModule config) {
        KField field = config.getField();
        String keyField = field.getKey();
        return Uarr.create((JsonArray)to).zip(from, keyField, keyField).to();
    }

    static JsonObject serializeP(JsonObject data, IxModule config) {
        JsonArray ref = Ut.sureJArray((JsonArray)data.getJsonArray("list"));
        data.put("list", IxSerialize.serializeA(ref, config));
        return data;
    }

    static JsonObject serializeJ(JsonObject data, IxModule config) {
        Ke.mount((JsonObject)data, (String)"metadata");
        KField field = config.getField();
        field.fieldObject().forEach(each -> Ke.mount((JsonObject)data, (String)each));
        field.fieldArray().forEach(each -> Ke.mountArray((JsonObject)data, (String)each));
        return data;
    }

    static JsonArray serializeA(JsonArray data, IxModule config) {
        if (Ut.isNil((JsonArray)data)) {
            return new JsonArray();
        }
        Ut.itJArray((JsonArray)data).forEach(refJson -> IxSerialize.serializeJ(refJson, config));
        return data;
    }

    static <T> T deserializeT(JsonObject data, IxModule config) {
        IxLog.infoDao(LOGGER, "Normalized: \n{0}", data.encodePrettily());
        Ke.mountString((JsonObject)data, (String)"metadata");
        KField field = config.getField();
        field.fieldArray().forEach(each -> Ke.mountString((JsonObject)data, (String)each));
        field.fieldObject().forEach(each -> Ke.mountString((JsonObject)data, (String)each));
        String pojo = config.getPojo();
        Object reference = Ut.isNil((String)pojo) ? Ux.fromJson((JsonObject)data, config.getPojoCls()) : Ux.fromJson((JsonObject)data, config.getPojoCls(), (String)config.getPojo());
        IxLog.infoDao(LOGGER, "Deserialized: {0}", reference);
        return (T)reference;
    }

    static <T> List<T> deserializeT(JsonArray data, IxModule config) {
        ArrayList list = new ArrayList();
        data.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(entity -> IxSerialize.deserializeT(entity, config)).forEach(reference -> list.add(reference));
        return list;
    }
}

