/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.crud.api;

import cn.vertxup.crud.api.Unity;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.actor.IxActor;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._409ModuleConflictException;
import io.vertx.tp.error._409MultiModuleException;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.exchange.DictFabric;
import io.vertx.up.exception.WebException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

@Queue
public class FileActor {
    private static final Annal LOGGER = Annal.get(FileActor.class);
    @Plugin
    private transient ExcelClient client;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/IMPORT")
    public Future<Envelop> importFile(Envelop request) {
        String actor = Ux.getString((Envelop)request);
        String filename = Ux.getString1((Envelop)request);
        Promise promise = Promise.promise();
        File file = new File(filename);
        if (file.exists()) {
            IxModule config = IxPin.getActor(actor);
            UxJooq jooq = IxPin.getDao(config, request.headers());
            Fn.safeJvm(() -> {
                FileInputStream inputStream = new FileInputStream(file);
                Set tables = this.client.ingest((InputStream)inputStream, true);
                ConcurrentHashMap tableMap = new ConcurrentHashMap();
                tables.stream().filter(Objects::nonNull).filter(item -> Objects.nonNull(item.getName())).forEach(item -> {
                    if (!tableMap.containsKey(item.getName())) {
                        HashSet tableSet = new HashSet();
                        tableMap.put(item.getName(), tableSet);
                    }
                    ((Set)tableMap.get(item.getName())).add(item);
                });
                if (1 == tableMap.size()) {
                    String tableName = (String)tableMap.keySet().iterator().next();
                    if (!tableName.equals(config.getTable())) {
                        promise.complete((Object)Envelop.failure((WebException)new _409ModuleConflictException(this.getClass(), tableName, config.getTable())));
                    } else {
                        Set filtered = (Set)tableMap.get(tableName);
                        ArrayList prepared = new ArrayList();
                        filtered.forEach(table -> {
                            List<JsonObject> records = table.get().stream().filter(Objects::nonNull).map(ExRecord::toJson).map(record -> IxActor.uuid().proc((JsonObject)record, config)).collect(Collectors.toList());
                            records.forEach(record -> {
                                IxActor.header().bind(request).proc((JsonObject)record, config);
                                if (Unity.isMatch(record, config)) {
                                    prepared.add(record);
                                }
                            });
                        });
                        Future result = Unity.fetchDict(request, config).compose(dictMap -> {
                            DictFabric fabric = Unity.fetchFabric(dictMap, config);
                            ArrayList futures = new ArrayList();
                            prepared.forEach(record -> {
                                record.put("active", Boolean.TRUE);
                                futures.add(IxActor.serial().bind(request).procAsync((JsonObject)record, config).compose(arg_0 -> ((DictFabric)fabric).inFrom(arg_0)).compose(normalized -> IxActor.unique().procAsync((JsonObject)normalized, config)).compose(filters -> Ix.search(filters, config).apply(jooq)).compose(queried -> Ix.isExist(queried) ? Ix.serializePO(queried, config).compose(item -> IxActor.update().bind(request).procAsync((JsonObject)item, config)).compose(item -> Ux.future((Object)item.mergeIn(record))).compose(json -> Ix.deserializeT(json, config)).compose(arg_0 -> ((UxJooq)jooq).updateAsync(arg_0)).compose(Ux::futureJ) : IxActor.uuid().procAsync((JsonObject)record, config).compose(item -> IxActor.create().bind(request).procAsync((JsonObject)item, config)).compose(item -> IxActor.update().bind(request).procAsync((JsonObject)item, config)).compose(json -> Ix.deserializeT(json, config)).compose(arg_0 -> ((UxJooq)jooq).insertAsync(arg_0)).compose(Ux::futureJ)));
                            });
                            return Ux.thenCombine(futures);
                        });
                        result.onComplete(imported -> {
                            Ix.infoDao(LOGGER, "Successfully to finish loading ! data file = {0}", filename);
                            promise.complete((Object)Envelop.success((Object)Boolean.TRUE));
                        });
                    }
                } else {
                    promise.complete((Object)Envelop.failure((WebException)new _409MultiModuleException(this.getClass(), tableMap.size())));
                }
            });
        } else {
            promise.complete((Object)Envelop.success((Object)Boolean.FALSE));
        }
        return promise.future();
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/EXPORT")
    public Future<Envelop> exportFile(Envelop request) {
        ConcurrentHashMap exportedHeaders = new ConcurrentHashMap();
        JsonArray removed = new JsonArray();
        ArrayList columnList = new ArrayList();
        return Ix.create(this.getClass()).input(request).envelop((dao, config) -> Unity.fetchFull(dao, request, config).compose(columns -> {
            HashSet columnSet = new HashSet();
            Ut.itJArray((JsonArray)columns, (column, index) -> {
                String columnKey = column.getString(IxPin.getColumnKey());
                String columnLabel = column.getString(IxPin.getColumnLabel());
                if (Ut.notNil((String)columnKey) && Ut.notNil((String)columnLabel)) {
                    exportedHeaders.put(columnKey, columnLabel);
                    columnSet.add(columnKey);
                }
            });
            return Ux.future(columnSet);
        }).compose(columnSet -> {
            JsonArray expected = Ux.getArray2((Envelop)request);
            columnSet.removeAll(expected.stream().filter(Objects::nonNull).map(column -> (String)column).collect(Collectors.toSet()));
            expected.stream().filter(Objects::nonNull).map(column -> (String)column).forEach(columnList::add);
            return Ux.future((Object)Ut.toJArray((Set)columnSet));
        }).compose(projection -> {
            removed.addAll(projection);
            JsonObject body = new JsonObject();
            JsonObject criteria = Ux.getJson1((Envelop)request);
            body.put("criteria", criteria);
            body.put("projection", projection);
            return Ux.future((Object)body);
        }).compose(input -> IxActor.verify().bind(request).procAsync((JsonObject)input, (IxModule)config)).compose(params -> Ix.query(params, config).apply((UxJooq)dao)).compose(response -> {
            JsonArray data = response.getJsonArray("list");
            if (Objects.isNull(data)) {
                data = new JsonArray();
            }
            JsonArray inputData = data.copy();
            return Unity.fetchDict(request, config).compose(Ut.ifNil(() -> inputData, dictMap -> Unity.fetchFabric(dictMap, config).inTo(inputData)));
        }).compose(data -> {
            removed.stream().map(item -> (String)item).forEach(exportedHeaders::remove);
            return Ke.combineAsync((JsonArray)data, (ConcurrentMap)exportedHeaders, (List)columnList);
        }).compose(data -> {
            String actor = Ux.getString((Envelop)request);
            return this.client.exportAsync(actor, data);
        }).compose(buffer -> Ux.future((Object)Envelop.success((Object)buffer))));
    }
}

