/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.crud.api;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.FileUpload;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Adjust;
import io.vertx.up.annotations.Codex;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import javax.ws.rs.BodyParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.StreamParam;

@EndPoint
@Path(value="/api")
public class FileAgent {
    private static final Annal LOGGER = Annal.get(FileAgent.class);

    @Path(value="/{actor}/import")
    @POST
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/IMPORT")
    @Adjust(value=10000000)
    public JsonObject importFile(@PathParam(value="actor") String actor, @StreamParam @Codex FileUpload fileUpload) {
        String filename = fileUpload.uploadedFileName();
        Ix.infoDao(LOGGER, "File information, filename = `{0}`, uploaded = `{1}`", fileUpload.fileName(), filename);
        return Ux.toZip((Object[])new Object[]{actor, filename});
    }

    @Path(value="/{actor}/export")
    @POST
    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03bc\u03bf\u03bd\u03ac\u03b4\u03b1 \u03bc\u03ad\u03c4\u03c1\u03b7\u03c3\u03b7\u03c2/X-FILE/EXPORT")
    @Adjust(value=10000000)
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public JsonObject exportFile(@PathParam(value="actor") String actor, @BodyParam JsonObject condition) {
        JsonObject query;
        JsonArray columns = condition.getJsonArray("columns");
        if (Objects.isNull(columns)) {
            columns = new JsonArray();
        }
        if (Ut.isNil((JsonObject)(query = condition.getJsonObject("criteria")))) {
            query = new JsonObject();
        }
        return Ux.toZip((Object[])new Object[]{actor, query, columns});
    }
}

