/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.crud.api;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.actor.IxActor;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.ke.atom.metadata.KField;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Apeak;
import io.vertx.tp.optic.Pocket;
import io.vertx.tp.optic.Seeker;
import io.vertx.tp.optic.component.Dictionary;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.exchange.DictConfig;
import io.vertx.up.commune.exchange.DictEpsilon;
import io.vertx.up.commune.exchange.DictFabric;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Unity {
    private static final Annal LOGGER = Annal.get(Unity.class);

    Unity() {
    }

    static DictFabric fetchFabric(ConcurrentMap<String, JsonArray> dictData, IxModule config) {
        return DictFabric.create().dictionary(dictData).epsilon(config.getEpsilon());
    }

    static Future<JsonObject> fetchView(UxJooq dao, Envelop request, IxModule config) {
        JsonObject params = Unity.initMy(request);
        return Ke.channel(Seeker.class, JsonObject::new, seeker -> Ux.future((Object)params).compose(input -> IxActor.header().bind(request).procAsync((JsonObject)input, config)).compose(arg_0 -> ((Seeker)seeker.on(dao)).fetchImpact(arg_0)));
    }

    static Future<JsonArray> fetchFull(UxJooq dao, Envelop request, IxModule config) {
        return Ke.channel(Apeak.class, JsonArray::new, stub -> IxActor.start().compose(input -> IxActor.apeak().bind(request).procAsync((JsonObject)input, config)).compose(input -> IxActor.header().bind(request).procAsync((JsonObject)input, config)).compose(arg_0 -> ((Apeak)stub.on(dao)).fetchFull(arg_0)));
    }

    static Future<ConcurrentMap<String, JsonArray>> fetchDict(Envelop request, IxModule config) {
        ConcurrentMap<String, DictEpsilon> epsilonMap = config.getEpsilon();
        Dictionary plugin = (Dictionary)Pocket.lookup(Dictionary.class);
        DictConfig dict = config.getSource();
        if (epsilonMap.isEmpty() || Objects.isNull(plugin) || !dict.validSource()) {
            Ix.infoRest(LOGGER, "Plugin condition failure, {0}, {1}, {2}", epsilonMap.isEmpty(), Objects.isNull(plugin), !dict.validSource());
            return Ux.future(new ConcurrentHashMap());
        }
        List sources = dict.getSource();
        MultiMap paramMap = MultiMap.caseInsensitiveMultiMap();
        JsonObject headers = request.headersX();
        paramMap.add("sigma", headers.getString("sigma"));
        return plugin.fetchAsync(paramMap, sources);
    }

    static boolean isMatch(JsonObject record, IxModule module) {
        KField fieldConfig = module.getField();
        JsonArray matrix = fieldConfig.getUnique();
        int size = matrix.size();
        for (int idx = 0; idx < size; ++idx) {
            JsonArray group = matrix.getJsonArray(idx);
            if (!Ut.notNil((JsonArray)group)) continue;
            HashSet fields = new HashSet();
            group.stream().filter(Objects::nonNull).map(item -> (String)item).filter(Ut::notNil).forEach(fields::add);
            boolean match = fields.stream().allMatch(field -> Objects.nonNull(record.getValue(field)));
            if (match) continue;
            Ix.warnRest(LOGGER, "Unique checking failure, check fields: `{0}`, data = {1}", Ut.fromJoin(fields), record.encode());
            return false;
        }
        return true;
    }

    static JsonObject initMy(Envelop envelop) {
        String pattern = "/api/{0}/search";
        String actor = Ux.getString((Envelop)envelop);
        return new JsonObject().put("uri", MessageFormat.format("/api/{0}/search", actor)).put("method", HttpMethod.POST.name());
    }
}

