/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.actor;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.crud.actor.IxActor;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import java.util.Objects;

public abstract class AbstractActor
implements IxActor {
    private final transient JsonObject metadata = new JsonObject();
    private transient Envelop envelop;
    private transient String user;
    private transient String habitus;

    @Override
    public IxActor bind(Envelop envelop) {
        this.envelop = envelop;
        User user = envelop.user();
        if (Objects.nonNull(user)) {
            this.initLogged(user);
        }
        return this;
    }

    private void initLogged(User user) {
        JsonObject principle = user.principal();
        if (principle.containsKey("metadata")) {
            this.metadata.mergeIn(principle.getJsonObject("metadata"));
        }
        this.user = Ke.keyUser((Envelop)this.envelop);
        this.habitus = Ke.keyHabitus((Envelop)this.envelop);
    }

    protected Envelop getRequest() {
        return this.envelop;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getHabitus() {
        return this.habitus;
    }

    protected JsonObject getMetadata() {
        return this.metadata;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

