/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.atom;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._404ModuleMissingException;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.function.BiFunction;

public class IxProc {
    private final transient Class<?> target;
    private transient IxModule config;
    private transient UxJooq jooq;
    private transient WebException ex;

    private IxProc(Class<?> clazz) {
        this.target = clazz;
    }

    public static IxProc create(Class<?> clazz) {
        return new IxProc(clazz);
    }

    private void logRequest(Envelop envelop) {
        HttpMethod method = envelop.method();
        String uri = envelop.uri();
        Annal logger = Annal.get(this.target);
        Ix.infoRest(logger, "---> Uri Addr: {0} {1}", method, uri);
    }

    public IxProc input(Envelop envelop) {
        String actor = Ux.getString((Envelop)envelop);
        try {
            this.config = IxPin.getActor(actor);
            this.jooq = IxPin.getDao(this.config, envelop.headers());
            if (null == this.jooq) {
                this.ex = new _404ModuleMissingException(this.target, actor);
            }
        }
        catch (WebException error) {
            error.printStackTrace();
            this.ex = error;
        }
        this.logRequest(envelop);
        return this;
    }

    public Future<Envelop> envelop(BiFunction<UxJooq, IxModule, Future<Envelop>> actuator) {
        WebException error = this.ex;
        if (null == error) {
            try {
                return actuator.apply(this.jooq, this.config);
            }
            catch (WebException ex) {
                return Future.failedFuture((Throwable)ex);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return Future.failedFuture((Throwable)ex);
            }
        }
        return Future.failedFuture((Throwable)error);
    }
}

