/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.MultiMap;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.init.IxConfiguration;
import io.vertx.tp.crud.init.IxDao;
import io.vertx.tp.crud.init.IxValidator;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.atom.Rule;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class IxPin {
    private static final Annal LOGGER = Annal.get(IxPin.class);

    public static void init() {
        Ke.banner((String)"\u300c\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7\u300d- Crud ( Ix )");
        Ix.infoInit(LOGGER, "IxConfiguration...", new Object[0]);
        IxConfiguration.init();
        Ix.infoInit(LOGGER, "IxDao...", new Object[0]);
        IxDao.init();
        Ix.infoInit(LOGGER, "IxValidator...", new Object[0]);
        IxValidator.init();
    }

    public static IxModule getActor(String actor) {
        return IxDao.get(actor);
    }

    public static UxJooq getDao(IxModule config, MultiMap headers) {
        return IxDao.get(config, headers);
    }

    public static Set<String> getUris() {
        return IxConfiguration.getUris();
    }

    public static ConcurrentMap<String, List<Rule>> getRules(String actor) {
        return IxValidator.getRules(actor);
    }

    public static String getColumnKey() {
        return IxConfiguration.getField();
    }

    public static String getColumnLabel() {
        return IxConfiguration.getLabel();
    }
}

