/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxModule;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.crud.refine.IxSerialize;
import io.vertx.tp.ke.atom.metadata.KField;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Function;

class IxQuery {
    private static final Annal LOGGER = Annal.get(IxQuery.class);

    IxQuery() {
    }

    static JsonObject inKeys(JsonArray array, IxModule config) {
        KField field = config.getField();
        String keyField = field.getKey();
        JsonObject filters = new JsonObject();
        JsonArray keys = new JsonArray();
        array.stream().filter(Objects::nonNull).forEach(item -> {
            if (JsonObject.class == item.getClass()) {
                String keyValue = ((JsonObject)item).getString(keyField);
                if (Ut.notNil((String)keyValue)) {
                    keys.add(keyValue);
                }
            } else {
                keys.add(item);
            }
        });
        return filters.put(keyField + ",i", keys);
    }

    static Function<UxJooq, Future<JsonObject>> query(JsonObject criteria, IxModule config) {
        String pojo = config.getPojo();
        return dao -> {
            IxLog.infoDao(LOGGER, "( JqTool ) Dao -> {0}, pojo = {1}", config.getDaoCls(), pojo);
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao.searchAsync(criteria).compose(response -> Ux.future((Object)IxSerialize.serializeP(response, config)));
        };
    }

    static Function<UxJooq, Future<JsonObject>> search(JsonObject filters, IxModule config) {
        String pojo = config.getPojo();
        return dao -> {
            IxLog.debugDao(LOGGER, "( Search ) Dao -> {0}, pojo = {1}", dao.getClass(), pojo);
            JsonObject criteria = new JsonObject();
            criteria.put("criteria", filters);
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao.searchAsync(criteria);
        };
    }

    static Function<UxJooq, Future<Boolean>> existing(JsonObject criteria, IxModule config) {
        String pojo = config.getPojo();
        JsonObject parameters = new JsonObject();
        if (Ut.notNil((String)pojo)) {
            parameters.mergeIn(Ux.criteria((JsonObject)criteria, (String)pojo));
        } else {
            parameters.mergeIn(criteria);
        }
        return dao -> {
            IxLog.infoDao(LOGGER, "( JqTool ) Dao -> {0}, pojo = {1}", dao.getClass(), pojo);
            return dao.existAsync(parameters);
        };
    }

    static void audit(JsonObject auditor, JsonObject config, String userId) {
        if (Objects.nonNull(config) && Ut.notNil((String)userId)) {
            String at;
            String by = config.getString("by");
            if (Ut.notNil((String)by)) {
                IxLog.infoDao(LOGGER, "( Audit ) By -> \"{0}\" = {1}", by, userId);
                auditor.put(by, userId);
            }
            if (Ut.notNil((String)(at = config.getString("at")))) {
                IxLog.infoDao(LOGGER, "( Audit ) At Field -> {0}", at);
                auditor.put(at, Instant.now());
            }
        }
    }
}

