/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxConfiguration;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.ke.atom.specification.KColumn;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KJoin;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.tp.ke.atom.specification.KPoint;
import io.vertx.tp.ke.cv.em.DSMode;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.environment.DS;
import io.vertx.tp.plugin.booting.KBoot;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Debugger;
import io.vertx.up.uca.jooq.UxJoin;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxDao {
    private static final ConcurrentMap<String, KModule> CONFIG_MAP = new ConcurrentHashMap<String, KModule>();
    private static final ConcurrentMap<String, String> ALIAS_MAP = new ConcurrentHashMap<String, String>();

    IxDao() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/module/", (String)"json");
        files.forEach(file -> {
            String path = "plugin/crud/module/" + file;
            JsonObject configDao = Ut.ioJObject((String)path);
            String identifierDefault = file.replace(".json", "");
            Fn.safeNull(() -> IxDao.addModule(configDao, identifierDefault), (Object[])new Object[]{configDao});
        });
        Set boots = KBoot.initialize();
        boots.forEach(boot -> {
            ConcurrentMap modules = boot.module();
            modules.forEach((moduleKey, json) -> {
                if (!CONFIG_MAP.containsKey(moduleKey) && !ALIAS_MAP.containsKey(moduleKey)) {
                    Fn.safeNull(() -> IxDao.addModule(json, moduleKey), (Object[])new Object[]{json});
                }
            });
        });
        Ix.Log.init(IxDao.class, "IxDao Finished ! Size = {0}, Uris = {0}", CONFIG_MAP.size(), IxConfiguration.getUris().size());
    }

    private static void addModule(JsonObject data, String identifierDefault) {
        KModule config = (KModule)Ut.deserialize((JsonObject)data, KModule.class);
        String identifier = IxDao.initValues(config, identifierDefault);
        IxConfiguration.addUrs(config.getName());
        CONFIG_MAP.put(config.getName(), config);
        ALIAS_MAP.put(identifier, config.getName());
        if (Debugger.isEnabled((String)"curd.dao.file")) {
            Ix.Log.init(IxDao.class, "--- identifier = {0} and name = {1}", identifier, config.getName());
        }
    }

    static KModule get(String actor) {
        KModule config = (KModule)CONFIG_MAP.get(actor);
        if (Objects.isNull(config)) {
            String name = (String)ALIAS_MAP.get(actor);
            if (Ut.notNil((String)name)) {
                Ix.Log.rest(IxDao.class, "Actor: name = `{0}`, identifier = `{1}`", name, actor);
                return (KModule)CONFIG_MAP.get(name);
            }
            return null;
        }
        Ix.Log.rest(IxDao.class, "Actor: name = `{0}`", actor);
        return config;
    }

    static UxJoin get(KModule module, KModule connect) {
        return (UxJoin)Fn.getNull(null, () -> {
            String pojoS;
            UxJoin dao = Ux.Join.on();
            String pojo = module.getPojo();
            dao.add(module.getDaoCls());
            if (Ut.notNil((String)pojo)) {
                dao.pojo(module.getDaoCls(), pojo);
            }
            KJoin join = module.getConnect();
            KPoint point = join.point(connect.getIdentifier());
            assert (null != point);
            Class daoCls = connect.getDaoCls();
            dao.join(daoCls, point.getKeyJoin());
            JsonObject synonym = point.getSynonym();
            if (Ut.notNil((JsonObject)synonym)) {
                Ut.itJObject((JsonObject)synonym, (aliasField, field) -> dao.alias(daoCls, field, aliasField));
            }
            if (Ut.notNil((String)(pojoS = connect.getPojo()))) {
                dao.pojo(connect.getDaoCls(), pojoS);
            }
            return dao;
        }, (Object[])new Object[]{module, connect});
    }

    static UxJooq get(KModule config, MultiMap headers) {
        return (UxJooq)Fn.getNull(null, () -> {
            Class daoCls = config.getDaoCls();
            assert (null != daoCls) : " Should not be null, check configuration";
            UxJooq dao = IxDao.get(config, daoCls, headers);
            String pojo = config.getPojo();
            if (Ut.notNil((String)pojo)) {
                dao.on(pojo);
            }
            return dao;
        }, (Object[])new Object[]{config});
    }

    private static String initValues(KModule module, String identifier) {
        JsonObject header;
        if (Objects.isNull(module.getColumn())) {
            KColumn column = new KColumn();
            column.setDynamic(Boolean.FALSE);
            column.setIdentifier(identifier);
            module.setColumn(column);
        }
        Fn.safeSemi((!(header = Ut.valueJObject((JsonObject)module.getHeader())).containsKey("sigma") ? 1 : 0) != 0, () -> header.put("sigma", (Object)"X-Sigma"));
        Fn.safeSemi((!header.containsKey("language") ? 1 : 0) != 0, () -> header.put("language", (Object)"X-Lang"));
        module.setHeader(header);
        KField field = Objects.isNull(module.getField()) ? new KField() : module.getField();
        Fn.safeSemi((boolean)Objects.isNull(field.getKey()), () -> field.setKey("key"));
        JsonObject created = Ut.valueJObject((JsonObject)field.getCreated());
        Fn.safeSemi((!created.containsKey("at") ? 1 : 0) != 0, () -> created.put("at", (Object)"createdAt"));
        Fn.safeSemi((!created.containsKey("by") ? 1 : 0) != 0, () -> created.put("by", (Object)"createdBy"));
        field.setCreated(created);
        JsonObject updated = Ut.valueJObject((JsonObject)field.getUpdated());
        Fn.safeSemi((!updated.containsKey("at") ? 1 : 0) != 0, () -> updated.put("at", (Object)"updatedAt"));
        Fn.safeSemi((!updated.containsKey("by") ? 1 : 0) != 0, () -> updated.put("by", (Object)"updatedBy"));
        field.setUpdated(updated);
        module.setField(field);
        return identifier;
    }

    private static UxJooq get(KModule module, Class<?> clazz, MultiMap headers) {
        String modeKey;
        DSMode mode = module.getMode();
        UxJooq dao = DSMode.DYNAMIC == mode ? (UxJooq)Ke.channelSync(DS.class, () -> Ux.Jooq.on((Class)clazz), ds -> Ux.Jooq.on((Class)clazz, (DataPool)ds.switchDs(headers))) : (DSMode.HISTORY == mode ? Ux.Jooq.ons(clazz) : (DSMode.EXTENSION == mode ? (Ut.isNil((String)(modeKey = module.getModeKey())) ? Ux.Jooq.on(clazz) : Ux.Jooq.on(clazz, (String)modeKey)) : Ux.Jooq.on(clazz)));
        return dao;
    }
}

