/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.IxData;
import io.vertx.tp.crud.refine.IxFn;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.crud.refine.IxSerialize;
import io.vertx.tp.crud.refine.IxType;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.atom.Kv;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Ix {
    public static void onAuditor(JsonObject auditor, JsonObject config, String userId) {
        IxData.audit(auditor, config, userId);
    }

    public static Kv<String, String> onColumn(Object value) {
        return IxData.field(value);
    }

    public static Kv<String, HttpMethod> onImpact(IxMod in) {
        return IxData.impact(in);
    }

    public static JsonArray onMatrix(KField field) {
        return IxData.matrix(field);
    }

    public static JsonObject onParameters(IxMod in) {
        return IxData.parameters(in);
    }

    public static TypeAtom onAtom(IxMod active, JsonArray columns) {
        return IxType.atom(active, columns);
    }

    public static Function<JsonObject, Future<JsonObject>> searchFn(IxMod in) {
        return IxFn.searchFn(in);
    }

    public static Function<JsonObject, Future<Long>> countFn(IxMod in) {
        return IxFn.countFn(in);
    }

    public static <T> BiFunction<Supplier<T>, BiFunction<UxJooq, JsonObject, Future<T>>, Future<T>> seekFn(IxMod in, Object json) {
        return IxFn.seekFn(in, json);
    }

    public static Function<JsonObject, Future<JsonArray>> fetchFn(IxMod in) {
        return IxFn.fetchFn(in);
    }

    public static Function<JsonObject, Future<JsonObject>> fileFn(IxMod in, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        return IxFn.fileFn(in, fileFn);
    }

    @SafeVarargs
    public static <T> Future<T> passion(T input, IxMod in, BiFunction<T, IxMod, Future<T>> ... executors) {
        return IxFn.passion(input, in, executors);
    }

    public static <T> Future<T> deserializeT(JsonObject data, KModule config) {
        Object reference = IxSerialize.deserializeT(data, config);
        return Ux.future(reference);
    }

    public static <T> Future<List<T>> deserializeT(JsonArray data, KModule config) {
        return Ux.future(IxSerialize.deserializeT(data, config));
    }

    public static <T> JsonObject serializeJ(T input, KModule config) {
        return IxSerialize.serializeJ(input, config);
    }

    public static <T> JsonArray serializeA(List<T> input, KModule config) {
        return IxSerialize.serializeA(input, config);
    }

    public static class Log {
        public static void filters(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoFilters(logger, pattern, args);
        }

        public static void init(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoInit(logger, pattern, args);
        }

        public static void rest(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoRest(logger, pattern, args);
        }

        public static void web(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoWeb(logger, pattern, args);
        }

        public static void restW(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.warnRest(logger, pattern, args);
        }

        public static void dao(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoDao(logger, pattern, args);
        }

        public static void verify(Class<?> clazz, String pattern, Object ... args) {
            Annal logger = Annal.get(clazz);
            IxLog.infoVerify(logger, pattern, args);
        }
    }
}

