/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.atom.Kv;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Objects;

class IxData {
    private static final Annal LOGGER = Annal.get(IxData.class);

    IxData() {
    }

    static void audit(JsonObject auditor, JsonObject config, String userId) {
        if (Objects.nonNull(config) && Ut.notNil((String)userId)) {
            String at;
            String by = config.getString("by");
            if (Ut.notNil((String)by)) {
                IxLog.infoDao(LOGGER, "( Audit ) By -> \"{0}\" = {1}", by, userId);
                auditor.put(by, (Object)userId);
            }
            if (Ut.notNil((String)(at = config.getString("at")))) {
                IxLog.infoDao(LOGGER, "( Audit ) At Field -> {0}", at);
                auditor.put(at, (Object)Instant.now());
            }
        }
    }

    static Kv<String, HttpMethod> impact(IxMod in) {
        KModule module = in.module();
        String pattern = "/api/{0}/search";
        String actor = module.getName();
        return Kv.create((Object)MessageFormat.format("/api/{0}/search", actor), (Object)HttpMethod.POST);
    }

    static Kv<String, String> field(Object value) {
        String fieldValue;
        String field;
        if ("HOLDER".equals(value)) {
            return null;
        }
        if (value instanceof String) {
            field = value.toString().split(",")[0];
            fieldValue = value.toString().split(",")[1];
        } else {
            JsonObject column = (JsonObject)value;
            if (column.containsKey("metadata")) {
                String metadata = column.getString("metadata");
                if (Ut.notNil((String)metadata)) {
                    field = metadata.split(",")[0];
                    fieldValue = value.toString().split(",")[1];
                } else {
                    field = null;
                    fieldValue = null;
                }
            } else {
                field = column.getString(IxPin.getColumnKey());
                fieldValue = column.getString(IxPin.getColumnLabel());
            }
        }
        if (Objects.nonNull(field) && Objects.nonNull(fieldValue)) {
            return Kv.create((Object)field, (Object)fieldValue);
        }
        return null;
    }

    static JsonArray matrix(KField field) {
        JsonArray priority = new JsonArray();
        String keyField = field.getKey();
        priority.add((Object)new JsonArray().add((Object)keyField));
        JsonArray matrix = Ut.valueJArray((JsonArray)field.getUnique());
        priority.addAll(matrix);
        return priority;
    }

    static JsonObject parameters(IxMod in) {
        JsonObject parameters = in.parameters();
        if (!parameters.containsKey("module")) {
            KModule module = in.module();
            KModule connect = in.connect();
            if (Objects.isNull(connect)) {
                parameters.put("module", (Object)module.getIdentifier());
            } else {
                parameters.put("module", (Object)connect.getIdentifier());
            }
        }
        return parameters;
    }
}

