/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.IxLog;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class IxSerialize {
    private static final Annal LOGGER = Annal.get(IxSerialize.class);

    IxSerialize() {
    }

    private static void serializeInternal(JsonObject data, KModule config) {
        Ut.ifJObject((JsonObject)data, (String[])new String[]{"metadata"});
        KField field = config.getField();
        field.fieldObject().forEach(each -> Ut.ifJObject((JsonObject)data, (String[])new String[]{each}));
        field.fieldArray().forEach(each -> Ut.ifJObject((JsonObject)data, (String[])new String[]{each}));
    }

    static <T> JsonObject serializeJ(T input, KModule module) {
        JsonObject serializedJ = input instanceof JsonObject ? (JsonObject)input : Ux.toJson(input, (String)module.getPojo());
        IxSerialize.serializeInternal(serializedJ, module);
        return serializedJ;
    }

    static <T> JsonArray serializeA(List<T> input, KModule module) {
        if (Objects.isNull(input)) {
            return new JsonArray();
        }
        JsonArray serializedA = input instanceof JsonArray ? (JsonArray)input : Ux.toJson(input, (String)module.getPojo());
        Ut.itJArray((JsonArray)serializedA).forEach(refJson -> IxSerialize.serializeInternal(refJson, module));
        return serializedA;
    }

    static <T> T deserializeT(JsonObject data, KModule config) {
        IxLog.infoDao(LOGGER, "Normalized: \u001b[0;37m{0}\u001b[m", data.encode());
        Ut.ifString((JsonObject)data, (String[])new String[]{"metadata"});
        KField field = config.getField();
        field.fieldArray().forEach(each -> Ut.ifString((JsonObject)data, (String[])new String[]{each}));
        field.fieldObject().forEach(each -> Ut.ifString((JsonObject)data, (String[])new String[]{each}));
        String pojo = config.getPojo();
        Object reference = Ut.isNil((String)pojo) ? Ux.fromJson((JsonObject)data, (Class)config.getPojoCls()) : Ux.fromJson((JsonObject)data, (Class)config.getPojoCls(), (String)config.getPojo());
        IxLog.infoDao(LOGGER, "Deserialized: {0}", reference);
        return (T)reference;
    }

    static <T> List<T> deserializeT(JsonArray data, KModule config) {
        ArrayList list = new ArrayList();
        data.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).map(entity -> IxSerialize.deserializeT(entity, config)).forEach(reference -> list.add(reference));
        return list;
    }
}

