/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.commune.element.TypeField;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.UxJooq;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxType {
    IxType() {
    }

    static TypeAtom atom(IxMod active, JsonArray columns) {
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        columns.stream().map(Ix::onColumn).filter(Objects::nonNull).forEach(kv -> headers.put((String)kv.getKey(), (String)kv.getValue()));
        TypeAtom atom = TypeAtom.create();
        KModule module = active.module();
        ArrayList<TypeField> fieldList = new ArrayList<TypeField>();
        KModule connect = active.connect();
        if (Objects.nonNull(connect)) {
            fieldList.addAll(IxType.field(connect, active.envelop(), headers));
        }
        fieldList.addAll(IxType.field(module, active.envelop(), headers));
        fieldList.forEach(arg_0 -> ((TypeAtom)atom).add(arg_0));
        return atom;
    }

    private static List<TypeField> field(KModule module, Envelop envelop, ConcurrentMap<String, String> headerMap) {
        UxJooq jooq = IxPin.jooq(module, envelop);
        JqAnalyzer analyzer = jooq.analyzer();
        ConcurrentMap typeMap = analyzer.types();
        ArrayList<TypeField> fieldList = new ArrayList<TypeField>();
        headerMap.forEach((field, alias) -> {
            Class<String> type = typeMap.getOrDefault(field, String.class);
            fieldList.add(TypeField.create((String)field, (String)alias, type));
        });
        return fieldList;
    }
}

