/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.desk;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._404ModuleMissingException;
import io.vertx.tp.ke.atom.specification.KJoin;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.tp.ke.atom.specification.KPoint;
import io.vertx.tp.ke.cv.em.JoinMode;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.exchange.BiMapping;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.BiFunction;

public class IxMod {
    private final transient JsonObject parameters = new JsonObject();
    private transient Envelop envelop;
    private transient KModule module;
    private transient KModule connect;
    private transient WebException error;

    private IxMod(String actor) {
        try {
            KModule module = IxPin.getActor(actor);
            Fn.out((boolean)Objects.isNull(module), _404ModuleMissingException.class, (Object[])new Object[]{this.getClass(), actor});
            this.module = module;
        }
        catch (WebException error) {
            error.printStackTrace();
            this.error = error;
        }
        catch (Throwable error) {
            error.printStackTrace();
            this.error = new _500InternalServerException(this.getClass(), error.getMessage());
        }
    }

    public static IxMod create(String actor) {
        return new IxMod(actor);
    }

    public String cacheKey() {
        if (Objects.isNull(this.connect)) {
            return this.module.getIdentifier();
        }
        return this.module.getIdentifier() + ":" + this.connect.getIdentifier();
    }

    public boolean canJoin() {
        return Objects.nonNull(this.connect);
    }

    public boolean canTransform() {
        return Objects.nonNull(this.module.getTransform());
    }

    public Envelop envelop() {
        return this.envelop;
    }

    public User user() {
        return this.envelop.user();
    }

    public JsonObject parameters() {
        return this.parameters.copy();
    }

    public KModule module() {
        return this.module;
    }

    public KModule connect() {
        return this.connect;
    }

    public String keyPool() {
        StringBuilder key = new StringBuilder();
        key.append(this.module.getIdentifier());
        if (this.canJoin()) {
            key.append(this.connect.getIdentifier());
        }
        return key.toString();
    }

    public IxMod bind(Envelop envelop) {
        this.envelop = envelop;
        JsonObject headers = envelop.headersX();
        this.parameters.mergeIn(headers, true);
        JsonObject parameters = envelop.body();
        if (Ut.notNil((JsonObject)parameters)) {
            this.parameters.mergeIn(parameters, true);
        }
        return this;
    }

    public IxMod connecting(Object input) {
        KJoin connect;
        if (Objects.isNull(input)) {
            return null;
        }
        if (input instanceof String) {
            this.parameters.put("module", (Object)((String)input));
        }
        if (Objects.isNull(connect = this.module.getConnect())) {
            return null;
        }
        KPoint target = null;
        if (input instanceof String) {
            String module = (String)input;
            target = connect.point(module);
        } else if (input instanceof JsonObject) {
            target = connect.point((JsonObject)input);
        } else if (input instanceof JsonArray) {
            target = connect.point((JsonArray)input);
        }
        if (Objects.nonNull(target) && JoinMode.CRUD == target.modeTarget()) {
            IxMod standBy = IxMod.create(target.getCrud()).bind(this.envelop);
            this.connect = standBy.module;
            return standBy;
        }
        return null;
    }

    public JsonArray dataIn(JsonArray input, JsonArray active) {
        JsonArray zip = new JsonArray();
        Ut.itJArray((JsonArray)active, (data, index) -> {
            JsonObject source = data.copy();
            JsonObject target = input.getJsonObject(index.intValue());
            if (Ut.notNil((JsonObject)target)) {
                zip.add((Object)source.mergeIn(target));
            } else {
                zip.add((Object)source);
            }
        });
        JsonArray normalized = new JsonArray();
        Ut.itJArray((JsonArray)zip).forEach(json -> {
            JsonObject dataSt = this.dataIn((JsonObject)json);
            normalized.add((Object)json.copy().mergeIn(dataSt, true));
        });
        return normalized;
    }

    public JsonObject dataIn(JsonObject input, JsonObject active) {
        KPoint point = this.point();
        KJoin connect = this.module.getConnect();
        JsonObject dataS = input.copy().mergeIn(active, true);
        connect.dataIn(dataS, point, dataS);
        if (Objects.nonNull(point)) {
            JsonObject converted = Ut.aiIn((JsonObject)dataS, (BiMapping)point.synonym(), (boolean)false);
            dataS.mergeIn(converted, true);
        }
        return dataS;
    }

    public JsonArray dataOut(JsonArray active, JsonArray standBy) {
        Ut.itJArray((JsonArray)standBy).forEach(json -> {
            JsonObject data = this.dataOut((JsonObject)json);
            json.mergeIn(data, true);
        });
        return Ut.elementZip((JsonArray)standBy, (JsonArray)active);
    }

    public JsonObject dataOut(JsonObject active, JsonObject standBy) {
        KPoint point = this.point();
        KJoin connect = this.module.getConnect();
        JsonObject standJ = standBy.copy();
        if (Objects.nonNull(point)) {
            JsonObject converted = Ut.aiOut((JsonObject)standJ, (BiMapping)point.synonym(), (boolean)false);
            standJ.mergeIn(converted, true);
        }
        JsonObject data = standJ.mergeIn(active, true);
        connect.dataOut(data, point, data);
        return data;
    }

    public JsonObject dataIn(JsonObject active) {
        KPoint point = this.point();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataIn(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataOut(JsonObject active) {
        KPoint point = this.point();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataOut(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataCond(JsonObject active) {
        KPoint point = this.point();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataCond(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataCond(JsonArray active) {
        JsonObject condition = new JsonObject();
        Ut.itJArray((JsonArray)active, (item, index) -> {
            JsonObject condEach = this.dataCond((JsonObject)item);
            if (Ut.notNil((JsonObject)condEach)) {
                condition.put("$" + index, (Object)condEach);
            }
        });
        return condition;
    }

    @SafeVarargs
    public final <T> Future<T> ready(T input, BiFunction<T, IxMod, Future<T>> ... executors) {
        if (Objects.nonNull((Object)this.error)) {
            return Future.failedFuture((Throwable)this.error);
        }
        return Ix.passion(input, this, executors);
    }

    private KPoint point() {
        if (this.canJoin()) {
            KJoin join = this.module.getConnect();
            if (Objects.isNull(join)) {
                return null;
            }
            KPoint point = join.point(this.connect.getIdentifier());
            Ix.Log.rest(this.getClass(), "Point = {0}, From = {1}, To = {2}", point, this.module.getIdentifier(), this.connect.getIdentifier());
            return point;
        }
        return null;
    }
}

