/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.input;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.atom.Rule;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.uca.rs.announce.Rigor;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;

class CodexPre
implements Pre {
    CodexPre() {
    }

    @Override
    public Future<JsonObject> inJAsync(JsonObject data, IxMod in) {
        Rigor rigor;
        WebException error;
        String key = this.getKey(data, in);
        Ix.Log.verify(this.getClass(), "---> Rule: {0}", key);
        ConcurrentMap<String, List<Rule>> rules = IxPin.getRules(key);
        if (!rules.isEmpty() && null != (error = (rigor = Rigor.get(JsonObject.class)).verify(rules, (Object)data))) {
            Ix.Log.verify(this.getClass(), "---> Error Code: {0}", String.valueOf(error.getCode()));
            throw error;
        }
        return Ux.future((Object)data);
    }

    private String getKey(JsonObject data, IxMod in) {
        Envelop envelop = in.envelop();
        KModule module = in.module();
        String uri = envelop.uri();
        if (uri.contains("?")) {
            uri = uri.split("\\?")[0];
        }
        String method = envelop.method().name();
        String keyField = module.getField().getKey();
        String keyValue = data.getString(keyField);
        if (Ut.notNil((String)keyValue)) {
            uri = uri.replace(keyValue, "$" + keyField);
        }
        return uri.toLowerCase(Locale.getDefault()).replace('/', '.').substring(1) + "." + method.toLowerCase(Locale.getDefault());
    }
}

