/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.op;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.tp.crud.uca.op.Agonic;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.function.BiFunction;

class AgonicUnique
implements Agonic {
    AgonicUnique() {
    }

    protected Future<JsonObject> fetchBy(JsonObject condition, IxMod in) {
        Ix.Log.filters(this.getClass(), "( Unique ) By: identifier: {0}, condition: {1}", in.module().getIdentifier(), condition);
        UxJooq jooq = IxPin.jooq(in);
        return jooq.fetchJOneAsync(condition);
    }

    protected Future<JsonObject> fetchByPk(JsonObject data, IxMod in) {
        UxJooq jooq = IxPin.jooq(in);
        return Pre.qPk().inJAsync(data, in).compose(condition -> {
            Ix.Log.filters(this.getClass(), "( Unique ) By Pk: identifier: {0}, condition: {1}", in.module().getIdentifier(), condition);
            return jooq.fetchJOneAsync(condition);
        });
    }

    protected Future<JsonObject> fetchByUk(JsonObject data, IxMod in) {
        UxJooq jooq = IxPin.jooq(in);
        return Pre.qUk().inJAsync(data, in).compose(condition -> {
            Ix.Log.filters(this.getClass(), "( Unique ) By Uk: identifier: {0}, condition: {1}", in.module().getIdentifier(), condition);
            return jooq.fetchJOneAsync(condition);
        });
    }

    @SafeVarargs
    protected final Future<JsonObject> runUnique(JsonObject data, IxMod in, BiFunction<JsonObject, IxMod, Future<JsonObject>> ... executors) {
        if (0 == executors.length) {
            return Ux.future((Object)new JsonObject());
        }
        Future first = executors[0].apply(data, in);
        int start = 1;
        while (start < executors.length) {
            int current = start++;
            first = first.compose(queried -> {
                if (Ut.isNil((JsonObject)queried)) {
                    return (Future)executors[current].apply(data, in);
                }
                return Ux.future((Object)queried);
            });
        }
        return first;
    }
}

