/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KJoin;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.tp.ke.atom.specification.KPoint;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.uca.jooq.UxJoin;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class IxFn {
    IxFn() {
    }

    static Function<JsonObject, Future<JsonObject>> fileFn(IxMod in, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        return data -> {
            KModule module = in.module();
            KField field = module.getField();
            if (Objects.isNull(field)) {
                return Ux.future((Object)data);
            }
            ConcurrentMap attachmentMap = field.fieldFile();
            return (Future)Ke.mapFn((ConcurrentMap)attachmentMap, (BiFunction)fileFn).apply(data);
        };
    }

    static Function<JsonObject, Future<JsonArray>> fetchFn(IxMod in) {
        return condition -> {
            KModule connect = in.connect();
            if (Objects.isNull(connect)) {
                UxJooq jooq = IxPin.jooq(in);
                return jooq.fetchJAsync(condition);
            }
            UxJoin join = IxPin.join(in, connect);
            return join.fetchAsync(condition);
        };
    }

    static Function<JsonObject, Future<JsonObject>> searchFn(IxMod in) {
        return condition -> {
            KModule connect = in.connect();
            if (Objects.isNull(connect)) {
                UxJooq jooq = IxPin.jooq(in);
                return jooq.searchAsync(condition);
            }
            UxJoin join = IxPin.join(in, connect);
            return join.searchAsync(condition);
        };
    }

    static Function<JsonObject, Future<Long>> countFn(IxMod in) {
        return condition -> {
            KModule connect = in.connect();
            if (Objects.isNull(connect)) {
                UxJooq jooq = IxPin.jooq(in);
                return jooq.countAsync(condition);
            }
            UxJoin join = IxPin.join(in, connect);
            return join.countAsync(condition);
        };
    }

    @SafeVarargs
    static <T> Future<T> passion(T input, IxMod in, BiFunction<T, IxMod, Future<T>> ... executors) {
        Future future = Future.succeededFuture(input);
        for (BiFunction executor : executors) {
            if (!Objects.nonNull(executor)) continue;
            future = future.compose(data -> (Future)executor.apply(data, in));
        }
        return future;
    }

    static <T> BiFunction<Supplier<T>, BiFunction<UxJooq, JsonObject, Future<T>>, Future<T>> seekFn(IxMod in, Object object) {
        return (supplier, executor) -> {
            UxJooq switchedJq;
            KModule module = in.module();
            KJoin join = module.getConnect();
            if (Objects.isNull(join)) {
                return Ux.future(supplier.get());
            }
            JsonObject filters = new JsonObject();
            if (object instanceof JsonObject) {
                JsonObject json = (JsonObject)object;
                KPoint point = join.point(json);
                KModule switched = IxPin.getActor(point.getCrud());
                switchedJq = IxPin.jooq(switched, in.envelop());
                join.dataIn(json, point, filters);
                if (Ut.isNil((String)switched.getPojo())) {
                    switchedJq.on(switched.getPojo());
                }
            } else {
                KPoint point;
                JsonArray records = (JsonArray)object;
                JsonObject json = records.getJsonObject(0);
                if (Ut.isNil((JsonObject)json)) {
                    switchedJq = null;
                    point = null;
                } else {
                    point = join.point(json);
                    KModule switched = IxPin.getActor(point.getCrud());
                    switchedJq = IxPin.jooq(switched, in.envelop());
                }
                if (Objects.nonNull(switchedJq)) {
                    Ut.itJArray((JsonArray)records).forEach(each -> {
                        JsonObject single = new JsonObject();
                        join.dataIn(each, point, single);
                        String key = "$" + single.hashCode();
                        filters.put(key, (Object)single);
                    });
                }
                filters.put("", (Object)Boolean.FALSE);
            }
            return (Future)executor.apply(switchedJq, filters);
        };
    }
}

