/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.desk;

import io.vertx.core.Future;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import java.util.List;

public final class IxKit {
    private static String STATUS = "$STATUS$";
    private static String RESULT = "$RESULT$";

    public static Future<Envelop> successPost(JsonObject input) {
        HttpStatusCode statusCode = IxKit.getStatus(input);
        return Ux.future((Object)Envelop.success((Object)input, (HttpStatusCode)statusCode));
    }

    public static Future<Envelop> successPostB(JsonObject input) {
        HttpStatusCode statusCode = IxKit.getStatus(input);
        Boolean result = input.getBoolean(RESULT, Boolean.FALSE);
        return Ux.future((Object)Envelop.success((Object)result, (HttpStatusCode)statusCode));
    }

    public static HttpStatusCode getStatus(JsonObject input) {
        HttpStatusCode statusCode;
        if (input.containsKey(STATUS)) {
            int status = input.getInteger(STATUS);
            statusCode = HttpStatusCode.fromCode((int)status);
            input.remove(STATUS);
        } else {
            statusCode = HttpStatusCode.OK;
        }
        return statusCode;
    }

    public static <T> Future<JsonObject> success201Pre(T input, KModule module) {
        return IxKit.successJ(input, module).compose(item -> {
            item.put(STATUS, (Object)201);
            return Ux.future((Object)item);
        });
    }

    public static <T> Future<JsonObject> success204Pre() {
        return Ux.future((Object)new JsonObject().put(STATUS, (Object)204));
    }

    public static <T> Future<JsonObject> success404Pre() {
        return Ux.future((Object)new JsonObject().put(STATUS, (Object)404));
    }

    public static Future<JsonObject> success200Pre(boolean result) {
        return Ux.future((Object)new JsonObject().put(STATUS, (Object)200).put(RESULT, (Object)result));
    }

    public static Future<JsonObject> success204Pre(boolean result) {
        return Ux.future((Object)new JsonObject().put(STATUS, (Object)204).put(RESULT, (Object)result));
    }

    public static <T> Future<JsonObject> successJ(T input, KModule module) {
        return Ux.future((Object)Ix.serializeJ(input, module));
    }

    public static <T> Future<JsonArray> successA(List<T> input, KModule module) {
        return Ux.future((Object)Ix.serializeA(input, module));
    }

    public static Future<JsonArray> ignoreA(JsonObject input, IxMod in) {
        return Ux.futureA();
    }
}

