/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.input;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.tp.ke.atom.specification.KField;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.environment.Indent;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;

class SerialPre
implements Pre {
    private static final Annal LOGGER = Annal.get(SerialPre.class);

    SerialPre() {
    }

    @Override
    public Future<JsonObject> inJAsync(JsonObject data, IxMod in) {
        String sigma = data.getString("sigma");
        if (Ut.isNil((String)sigma)) {
            return Ux.future((Object)data);
        }
        return this.run(data, in, numbers -> Ke.channelAsync(Indent.class, () -> Ux.future((Object)data), stub -> {
            Ke.infoKe((Annal)LOGGER, (String)"Table here {0}, Serial numbers {1}", (Object[])new Object[]{in.module().getTable(), numbers.encode()});
            ConcurrentHashMap numberMap = new ConcurrentHashMap();
            numbers.fieldNames().stream().filter(numberField -> !data.containsKey(numberField)).filter(numberField -> Objects.nonNull(numbers.getString(numberField))).forEach(numberField -> {
                String code = numbers.getString(numberField);
                numberMap.put(numberField, stub.indent(code, sigma));
            });
            return Ux.thenCombine(numberMap).compose(generated -> {
                generated.forEach((arg_0, arg_1) -> ((JsonObject)data).put(arg_0, arg_1));
                return Ux.future((Object)data);
            });
        }));
    }

    @Override
    public Future<JsonArray> inAAsync(JsonArray data, IxMod in) {
        String sigma = Ut.valueString((JsonArray)data, (String)"sigma");
        if (Ut.isNil((String)sigma) || Ut.isNil((JsonArray)data)) {
            return Ux.future((Object)data);
        }
        return this.run(data, in, numbers -> Ke.channelAsync(Indent.class, () -> Ux.future((Object)data), stub -> {
            Ke.infoKe((Annal)LOGGER, (String)"Table here {0}, Size {1}, Serial numbers {2}", (Object[])new Object[]{in.module().getTable(), data.size(), numbers.encode()});
            ConcurrentHashMap numberMap = new ConcurrentHashMap();
            numbers.fieldNames().stream().filter(numberField -> Objects.nonNull(numbers.getString(numberField))).forEach(numberField -> {
                String code = numbers.getString(numberField);
                numberMap.put(numberField, stub.indent(code, sigma, data.size()).compose(queue -> Ux.future(new ArrayList(queue))));
            });
            return Ux.thenCombine(numberMap).compose(generated -> {
                generated.forEach((numberField, numberList) -> {
                    LinkedBlockingDeque numberQueue = new LinkedBlockingDeque(numberList);
                    if (numberQueue.size() == data.size()) {
                        Ut.itJArray((JsonArray)data).forEach(json -> json.put(numberField, numberQueue.poll()));
                    }
                });
                return Ux.future((Object)data);
            });
        }));
    }

    private <T> Future<T> run(T data, IxMod in, Function<JsonObject, Future<T>> executor) {
        KModule module = in.module();
        KField field = module.getField();
        JsonObject numbers = field.getNumbers();
        if (Ut.isNil((JsonObject)numbers)) {
            return Ux.future(data);
        }
        return executor.apply(numbers);
    }
}

