/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.trans;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.trans.Tran;
import io.vertx.tp.ke.atom.specification.KModule;
import io.vertx.tp.ke.atom.specification.KTransform;
import io.vertx.tp.optic.Pocket;
import io.vertx.tp.optic.component.Dictionary;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.exchange.DiFabric;
import io.vertx.up.commune.exchange.DiSetting;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class FabricTran
implements Tran {
    private final transient boolean isFrom;

    FabricTran(boolean isFrom) {
        this.isFrom = isFrom;
    }

    @Override
    public Future<JsonObject> inJAsync(JsonObject data, IxMod in) {
        if (in.canTransform()) {
            return this.fabric(in).compose(Ut.ifNil(() -> data, fabric -> this.isFrom ? fabric.inFrom(data) : fabric.inTo(data)));
        }
        return Ux.future((Object)data);
    }

    @Override
    public Future<JsonArray> inAAsync(JsonArray data, IxMod in) {
        if (in.canTransform()) {
            return this.fabric(in).compose(Ut.ifNil(() -> data, fabric -> this.isFrom ? fabric.inFrom(data) : fabric.inTo(data)));
        }
        return Ux.future((Object)data);
    }

    private Future<DiFabric> fabric(IxMod in) {
        Envelop envelop = in.envelop();
        KModule module = in.module();
        KTransform transform = module.getTransform();
        return this.fabric(module, envelop).compose(dictData -> {
            ConcurrentHashMap dictMap = new ConcurrentHashMap(dictData);
            if (in.canJoin()) {
                KModule connect = in.connect();
                KTransform transformConnect = connect.getTransform();
                ConcurrentMap connectConsumer = transform.epsilon();
                if (Objects.nonNull(transformConnect)) {
                    connectConsumer.putAll(transformConnect.epsilon());
                }
                return this.fabric(connect, envelop).compose(dictConnect -> {
                    dictMap.putAll(dictConnect);
                    return Ux.future((Object)DiFabric.create().dictionary(dictMap).epsilon(connectConsumer));
                });
            }
            return Ux.future((Object)DiFabric.create().dictionary(dictMap).epsilon(transform.epsilon()));
        });
    }

    private Future<ConcurrentMap<String, JsonArray>> fabric(KModule module, Envelop envelop) {
        KTransform transform = module.getTransform();
        if (Objects.isNull(transform)) {
            return Ux.future(new ConcurrentHashMap());
        }
        ConcurrentMap epsilonMap = transform.epsilon();
        Dictionary plugin = (Dictionary)Pocket.lookup(Dictionary.class);
        DiSetting dict = transform.source();
        if (epsilonMap.isEmpty() || Objects.isNull(plugin) || !dict.validSource()) {
            Ix.Log.rest(this.getClass(), "Plugin condition failure, {0}, {1}, {2}", epsilonMap.isEmpty(), Objects.isNull(plugin), !dict.validSource());
            return Ux.future(new ConcurrentHashMap());
        }
        List sources = dict.getSource();
        MultiMap paramMap = MultiMap.caseInsensitiveMultiMap();
        JsonObject headers = envelop.headersX();
        paramMap.add("sigma", headers.getString("sigma"));
        return plugin.fetchAsync(paramMap, sources);
    }
}

