/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.atom.IxConfig;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

class IxConfiguration {
    private static final Set<String> MODULE_REG = new HashSet<String>();
    private static IxConfig CONFIG = null;

    IxConfiguration() {
    }

    static void init() {
        if (null == CONFIG) {
            JsonObject configData = Ut.ioJObject((String)"plugin/crud/configuration.json");
            Ix.LOG.Init.info(IxConfiguration.class, "Ix Json Data: {0}", new Object[]{configData.encode()});
            CONFIG = (IxConfig)Ut.deserialize((JsonObject)configData, IxConfig.class);
            Ix.LOG.Init.info(IxConfiguration.class, "Ix Configuration: {0}", new Object[]{CONFIG.toString()});
        }
    }

    static void addUrs(String key) {
        JsonArray patterns = CONFIG.getPatterns();
        patterns.stream().map(item -> (String)item).map(pattern -> MessageFormat.format(pattern, key)).forEach(MODULE_REG::add);
    }

    static Set<String> getUris() {
        return MODULE_REG;
    }

    static String getField() {
        return CONFIG.getColumnKeyField();
    }

    static String getLabel() {
        return CONFIG.getColumnLabelField();
    }
}

