/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.init;

import io.aeon.experiment.specification.KColumn;
import io.aeon.experiment.specification.KField;
import io.aeon.experiment.specification.KModule;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxConfiguration;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.plugin.booting.KBoot;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.log.DevEnv;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxDao {
    private static final ConcurrentMap<String, KModule> CONFIG_MAP = new ConcurrentHashMap<String, KModule>();
    private static final ConcurrentMap<String, String> ALIAS_MAP = new ConcurrentHashMap<String, String>();

    IxDao() {
    }

    static void init() {
        List files = Ut.ioFiles((String)"plugin/crud/module/", (String)"json");
        files.forEach(file -> {
            String path = "plugin/crud/module/" + file;
            JsonObject configDao = Ut.ioJObject((String)path);
            String identifierDefault = file.replace(".json", "");
            Fn.runAt(() -> IxDao.addModule(configDao, identifierDefault), (Object[])new Object[]{configDao});
        });
        Set boots = KBoot.initialize();
        boots.forEach(boot -> {
            ConcurrentMap modules = boot.module();
            modules.forEach((moduleKey, json) -> {
                if (!CONFIG_MAP.containsKey(moduleKey) && !ALIAS_MAP.containsKey(moduleKey)) {
                    Fn.runAt(() -> IxDao.addModule(json, moduleKey), (Object[])new Object[]{json});
                }
            });
        });
        Ix.LOG.Init.info(IxDao.class, "IxDao Finished ! Size = {0}, Uris = {0}", new Object[]{CONFIG_MAP.size(), IxConfiguration.getUris().size()});
    }

    private static void addModule(JsonObject data, String identifierDefault) {
        KModule config = (KModule)Ut.deserialize((JsonObject)data, KModule.class);
        String identifier = IxDao.initValues(config, identifierDefault);
        IxConfiguration.addUrs(config.getName());
        CONFIG_MAP.put(config.getName(), config);
        ALIAS_MAP.put(identifier, config.getName());
        if (DevEnv.devDaoBind()) {
            Ix.LOG.Init.info(IxDao.class, "--- identifier = {0} and name = {1}", new Object[]{identifier, config.getName()});
        }
    }

    static KModule get(String actor) {
        KModule config = (KModule)CONFIG_MAP.get(actor);
        if (Objects.isNull(config)) {
            String name = (String)ALIAS_MAP.get(actor);
            if (Ut.isNotNil((String)name)) {
                Ix.LOG.Rest.info(IxDao.class, "Actor: name = `{0}`, identifier = `{1}`", new Object[]{name, actor});
                return (KModule)CONFIG_MAP.get(name);
            }
            return null;
        }
        Ix.LOG.Rest.info(IxDao.class, "Actor: name = `{0}`", new Object[]{actor});
        return config;
    }

    private static String initValues(KModule module, String identifier) {
        JsonObject header;
        if (Objects.isNull(module.getColumn())) {
            KColumn column = new KColumn();
            column.setDynamic(Boolean.FALSE);
            column.setIdentifier(identifier);
            module.setColumn(column);
        }
        Fn.runAt((!(header = Ut.valueJObject((JsonObject)module.getHeader())).containsKey("sigma") ? 1 : 0) != 0, () -> header.put("sigma", (Object)"X-Sigma"));
        Fn.runAt((!header.containsKey("language") ? 1 : 0) != 0, () -> header.put("language", (Object)"X-Lang"));
        module.setHeader(header);
        KField field = Objects.isNull(module.getField()) ? new KField() : module.getField();
        Fn.runAt((boolean)Objects.isNull(field.getKey()), () -> field.setKey("key"));
        JsonObject created = Ut.valueJObject((JsonObject)field.getCreated());
        Fn.runAt((!created.containsKey("at") ? 1 : 0) != 0, () -> created.put("at", (Object)"createdAt"));
        Fn.runAt((!created.containsKey("by") ? 1 : 0) != 0, () -> created.put("by", (Object)"createdBy"));
        field.setCreated(created);
        JsonObject updated = Ut.valueJObject((JsonObject)field.getUpdated());
        Fn.runAt((!updated.containsKey("at") ? 1 : 0) != 0, () -> updated.put("at", (Object)"updatedAt"));
        Fn.runAt((!updated.containsKey("by") ? 1 : 0) != 0, () -> updated.put("by", (Object)"updatedBy"));
        field.setUpdated(updated);
        module.setField(field);
        return identifier;
    }
}

