/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.aeon.experiment.specification.KField;
import io.aeon.experiment.specification.KModule;
import io.horizon.atom.common.Kv;
import io.horizon.uca.log.Log;
import io.horizon.uca.log.LogModule;
import io.modello.atom.typed.MetaAtom;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.IxData;
import io.vertx.tp.crud.refine.IxFn;
import io.vertx.tp.crud.refine.IxSerialize;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.uca.sectio.Aspect;
import io.vertx.up.unity.Ux;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class Ix {
    public static void onAuditor(JsonObject auditor, JsonObject config, String userId) {
        IxData.audit(auditor, config, userId);
    }

    public static Kv<String, String> onColumn(Object value) {
        return IxData.field(value);
    }

    public static Kv<String, HttpMethod> onImpact(IxMod in) {
        return IxData.impact(in);
    }

    public static JsonArray onMatrix(KField field) {
        return IxData.matrix(field);
    }

    public static JsonObject onParameters(IxMod in) {
        return IxData.parameters(in);
    }

    public static MetaAtom onAtom(IxMod active, JsonArray columns) {
        return IxData.atom(active, columns);
    }

    public static Function<JsonObject, Future<JsonObject>> searchFn(IxMod in) {
        return IxFn.searchFn(in);
    }

    public static Function<JsonObject, Future<Long>> countFn(IxMod in) {
        return IxFn.countFn(in);
    }

    public static <T> BiFunction<Supplier<T>, BiFunction<UxJooq, JsonObject, Future<T>>, Future<T>> seekFn(IxMod in, Object json) {
        return IxFn.seekFn(in, json);
    }

    public static Function<JsonObject, Future<JsonArray>> fetchFn(IxMod in) {
        return IxFn.fetchFn(in);
    }

    public static Function<JsonObject, Future<JsonObject>> fileFn(IxMod in, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        return IxFn.fileFn(in, fileFn);
    }

    @SafeVarargs
    public static <T> Future<T> passion(T input, IxMod in, BiFunction<T, IxMod, Future<T>> ... executors) {
        return IxFn.passion(input, in, executors);
    }

    public static <T> Function<T, Future<T>> wrap(KModule module, BiFunction<Aspect, Function<T, Future<T>>, Function<T, Future<T>>> aopFn, Function<T, Future<T>> executor) {
        return IxFn.wrap(module, aopFn, executor);
    }

    public static <T> Future<T> deserializeT(JsonObject data, KModule config) {
        Object reference = IxSerialize.deserializeT(data, config);
        return Ux.future(reference);
    }

    public static <T> Future<List<T>> deserializeT(JsonArray data, KModule config) {
        return Ux.future(IxSerialize.deserializeT(data, config));
    }

    public static <T> JsonObject serializeJ(T input, KModule config) {
        return IxSerialize.serializeJ(input, config);
    }

    public static <T> JsonArray serializeA(List<T> input, KModule config) {
        return IxSerialize.serializeA(input, config);
    }

    public static JsonObject serializeP(JsonObject pageData, KModule active, KModule standBy) {
        return IxSerialize.serializeP(pageData, active, standBy);
    }

    public static interface LOG {
        public static final String MODULE = "\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7";
        public static final LogModule Filter = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Filter");
        public static final LogModule Init = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Init");
        public static final LogModule Rest = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Rest");
        public static final LogModule Web = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Web");
        public static final LogModule Dao = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Dao");
        public static final LogModule Verify = Log.modulat((String)"\u0395\u03ba\u03b4\u03ae\u03bb\u03c9\u03c3\u03b7").program("Verify");
    }
}

