/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.refine;

import io.aeon.experiment.specification.KField;
import io.aeon.experiment.specification.KModule;
import io.horizon.atom.common.Kv;
import io.horizon.uca.log.Annal;
import io.modello.atom.typed.MetaAtom;
import io.modello.atom.typed.MetaField;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.up.commune.Envelop;
import io.vertx.up.uca.jooq.JqAnalyzer;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IxData {
    private static final Annal LOGGER = Annal.get(IxData.class);

    IxData() {
    }

    static void audit(JsonObject auditor, JsonObject config, String userId) {
        if (Objects.nonNull(config) && Ut.isNotNil((String)userId)) {
            String at;
            String by = config.getString("by");
            if (Ut.isNotNil((String)by)) {
                Ix.LOG.Dao.info(LOGGER, "( Audit ) By -> \"{0}\" = {1}", new Object[]{by, userId});
                auditor.put(by, (Object)userId);
            }
            if (Ut.isNotNil((String)(at = config.getString("at")))) {
                Ix.LOG.Dao.info(LOGGER, "( Audit ) At Field -> {0}", new Object[]{at});
                auditor.put(at, (Object)Instant.now());
            }
        }
    }

    static Kv<String, HttpMethod> impact(IxMod in) {
        KModule module = in.module();
        String pattern = "/api/{0}/search";
        String actor = module.getName();
        return Kv.create((Object)MessageFormat.format("/api/{0}/search", actor), (Object)HttpMethod.POST);
    }

    static Kv<String, String> field(Object value) {
        String fieldValue;
        String field;
        if ("HOLDER".equals(value)) {
            return null;
        }
        if (value instanceof String) {
            field = value.toString().split(",")[0];
            fieldValue = value.toString().split(",")[1];
        } else {
            JsonObject column = (JsonObject)value;
            if (column.containsKey("metadata")) {
                String metadata = column.getString("metadata");
                if (Ut.isNotNil((String)metadata)) {
                    field = metadata.split(",")[0];
                    fieldValue = value.toString().split(",")[1];
                } else {
                    field = null;
                    fieldValue = null;
                }
            } else {
                field = column.getString(IxPin.getColumnKey());
                fieldValue = column.getString(IxPin.getColumnLabel());
            }
        }
        if (Objects.nonNull(field) && Objects.nonNull(fieldValue)) {
            return Kv.create((Object)field, (Object)fieldValue);
        }
        return null;
    }

    static JsonArray matrix(KField field) {
        JsonArray priority = new JsonArray();
        String keyField = field.getKey();
        priority.add((Object)new JsonArray().add((Object)keyField));
        JsonArray matrix = Ut.valueJArray((JsonArray)field.getUnique());
        priority.addAll(matrix);
        return priority;
    }

    static JsonObject parameters(IxMod in) {
        JsonObject parameters = in.parameters();
        if (!parameters.containsKey("module")) {
            KModule module = in.module();
            KModule connect = in.connect();
            if (Objects.isNull(connect)) {
                parameters.put("module", (Object)module.identifier());
            } else {
                parameters.put("module", (Object)connect.identifier());
            }
        }
        return parameters;
    }

    static MetaAtom atom(IxMod active, JsonArray columns) {
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        columns.stream().map(Ix::onColumn).filter(Objects::nonNull).forEach(kv -> headers.put((String)kv.key(), (String)kv.value()));
        MetaAtom atom = MetaAtom.create();
        KModule module = active.module();
        ArrayList<MetaField> fieldList = new ArrayList<MetaField>();
        KModule connect = active.connect();
        if (Objects.nonNull(connect)) {
            fieldList.addAll(IxData.field(connect, active.envelop(), headers));
        }
        fieldList.addAll(IxData.field(module, active.envelop(), headers));
        fieldList.forEach(arg_0 -> ((MetaAtom)atom).add(arg_0));
        return atom;
    }

    private static List<MetaField> field(KModule module, Envelop envelop, ConcurrentMap<String, String> headerMap) {
        UxJooq jooq = IxPin.jooq(module, envelop);
        JqAnalyzer analyzer = jooq.analyzer();
        ConcurrentMap typeMap = analyzer.types();
        ArrayList<MetaField> fieldList = new ArrayList<MetaField>();
        headerMap.forEach((field, alias) -> {
            Class<String> type = typeMap.getOrDefault(field, String.class);
            fieldList.add(MetaField.create((String)field, (String)alias, type));
        });
        return fieldList;
    }
}

