/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.desk;

import io.aeon.experiment.specification.KJoin;
import io.aeon.experiment.specification.KModule;
import io.aeon.experiment.specification.KPoint;
import io.horizon.eon.em.scheduler.JoinMode;
import io.horizon.exception.WebException;
import io.horizon.exception.web._500InternalServerException;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.error._404ModuleMissingException;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.exchange.BMapping;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class IxMod {
    private final transient JsonObject parameters = new JsonObject();
    private transient Envelop envelop;
    private transient KModule module;
    private transient KModule connect;
    private transient WebException error;

    private IxMod(String actor) {
        try {
            KModule module = IxPin.getActor(actor);
            Fn.out((boolean)Objects.isNull(module), _404ModuleMissingException.class, (Object[])new Object[]{this.getClass(), actor});
            this.module = module;
        }
        catch (WebException error) {
            error.printStackTrace();
            this.error = error;
        }
        catch (Throwable error) {
            error.printStackTrace();
            this.error = new _500InternalServerException(this.getClass(), error.getMessage());
        }
    }

    public static IxMod create(String actor) {
        return new IxMod(actor);
    }

    public String cacheKey() {
        if (Objects.isNull(this.connect)) {
            return this.module.identifier();
        }
        return this.module.identifier() + ":" + this.connect.identifier();
    }

    public boolean canJoin() {
        return Objects.nonNull(this.connect);
    }

    public boolean canTransform() {
        return Objects.nonNull(this.module.getTransform());
    }

    public Envelop envelop() {
        return this.envelop;
    }

    public User user() {
        return this.envelop.user();
    }

    public JsonObject parameters() {
        return this.parameters.copy();
    }

    public KModule module() {
        return this.module;
    }

    public KModule connect() {
        return this.connect;
    }

    public String keyPool() {
        StringBuilder key = new StringBuilder();
        key.append(this.module.identifier());
        if (this.canJoin()) {
            key.append(this.connect.identifier());
        }
        return key.toString();
    }

    public IxMod bind(Envelop envelop) {
        this.envelop = envelop;
        JsonObject headers = envelop.headersX();
        this.parameters.mergeIn(headers, true);
        JsonObject parameters = envelop.body();
        if (Ut.isNotNil((JsonObject)parameters)) {
            this.parameters.mergeIn(parameters, true);
        }
        return this;
    }

    public IxMod connecting(Object input) {
        KJoin connect;
        if (Objects.isNull(input)) {
            return null;
        }
        if (input instanceof String) {
            this.parameters.put("module", (Object)((String)input));
        }
        if (Objects.isNull(connect = this.module.getConnect())) {
            return null;
        }
        KPoint target = null;
        if (input instanceof String) {
            String module = (String)input;
            target = connect.point(module);
        } else if (input instanceof JsonObject) {
            target = connect.point((JsonObject)input);
        } else if (input instanceof JsonArray) {
            target = connect.point((JsonArray)input);
        }
        if (Objects.nonNull(target) && JoinMode.CRUD == target.modeTarget()) {
            IxMod standBy = IxMod.create(target.getCrud()).bind(this.envelop);
            this.connect = standBy.module;
            return standBy;
        }
        return null;
    }

    public JsonArray dataIn(JsonArray input, JsonArray active) {
        JsonArray zip = new JsonArray();
        this.zipData(input, active, (source, target) -> {
            JsonObject normalized = Ut.isNil((JsonObject)target) ? this.dataIn((JsonObject)source) : this.dataIn((JsonObject)source, (JsonObject)target);
            zip.add((Object)normalized);
        });
        return zip;
    }

    public JsonArray dataOut(JsonArray active, JsonArray standBy) {
        JsonArray zip = new JsonArray();
        this.zipData(active, standBy, (source, target) -> {
            JsonObject normalized = Ut.isNil((JsonObject)target) ? this.dataOut((JsonObject)source) : this.dataOut((JsonObject)source, (JsonObject)target);
            zip.add((Object)normalized);
        });
        return zip;
    }

    public JsonObject dataIn(JsonObject input, JsonObject active) {
        KPoint point = this.pointJoin();
        KJoin connect = this.module.getConnect();
        JsonObject dataS = input.copy().mergeIn(active, true);
        connect.dataIn(dataS, point, dataS);
        if (Objects.nonNull(point)) {
            JsonObject converted = Ut.aiIn((JsonObject)dataS, (BMapping)point.synonym(), (boolean)false);
            dataS.mergeIn(converted, true);
        }
        return dataS;
    }

    public JsonObject dataOut(JsonObject active, JsonObject standBy) {
        KPoint point = this.pointJoin();
        KJoin connect = this.module.getConnect();
        JsonObject standJ = standBy.copy();
        if (Objects.nonNull(point)) {
            JsonObject converted = Ut.aiOut((JsonObject)standJ, (BMapping)point.synonym(), (boolean)false);
            standJ.mergeIn(converted, true);
        }
        JsonObject data = standJ.mergeIn(active, true);
        connect.dataOut(data, point, data);
        return data;
    }

    private void zipData(JsonArray active, JsonArray standBy, BiConsumer<JsonObject, JsonObject> consumerFn) {
        this.zipData((sourceKey, targetKey) -> Ut.itJArray((JsonArray)active).forEach(sourceJ -> {
            Objects.requireNonNull(sourceKey);
            Object value = sourceJ.getValue(sourceKey);
            if (Objects.isNull(targetKey) || Objects.isNull(value)) {
                consumerFn.accept((JsonObject)sourceJ, (JsonObject)null);
            } else {
                JsonObject found = Ut.elementFind((JsonArray)standBy, (String)targetKey, (Object)value);
                consumerFn.accept((JsonObject)sourceJ, found);
            }
        }));
    }

    private void zipData(BiConsumer<String, String> joinFn) {
        KPoint point;
        KPoint point2;
        KJoin connect = this.module.getConnect();
        String sourceKey = Objects.isNull(connect) ? "key" : (Objects.isNull(point2 = connect.getSource()) ? "key" : (Ut.isNil((String)point2.getKeyJoin()) ? "key" : point2.getKeyJoin()));
        String targetKey = null;
        if (this.canJoin() && Objects.nonNull(point = this.pointJoin())) {
            targetKey = point.getKeyJoin();
        }
        joinFn.accept(sourceKey, targetKey);
    }

    public JsonObject dataIn(JsonObject active) {
        KPoint point = this.pointJoin();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataIn(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataOut(JsonObject active) {
        KPoint point = this.pointJoin();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataOut(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataCond(JsonObject active) {
        KPoint point = this.pointJoin();
        KJoin connect = this.module.getConnect();
        JsonObject condJoin = new JsonObject();
        connect.dataCond(active, point, condJoin);
        return condJoin;
    }

    public JsonObject dataCond(JsonArray active) {
        JsonObject condition = new JsonObject();
        Ut.itJArray((JsonArray)active, (item, index) -> {
            JsonObject condEach = this.dataCond((JsonObject)item);
            if (Ut.isNotNil((JsonObject)condEach)) {
                condition.put("$" + index, (Object)condEach);
            }
        });
        return condition;
    }

    public KPoint pointJoin() {
        if (this.canJoin()) {
            KJoin join = this.module.getConnect();
            if (Objects.isNull(join)) {
                return null;
            }
            KPoint point = join.point(this.connect.identifier());
            Ix.LOG.Rest.info(this.getClass(), "Point = {0}, From = {1}, To = {2}", new Object[]{point, this.module.identifier(), this.connect.identifier()});
            return point;
        }
        return null;
    }

    @SafeVarargs
    public final <T> Future<T> ready(T input, BiFunction<T, IxMod, Future<T>> ... executors) {
        if (Objects.nonNull((Object)this.error)) {
            return Future.failedFuture((Throwable)this.error);
        }
        return Ix.passion(input, this, executors);
    }
}

