/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.desk;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.desk.IxWeb;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IxPanel {
    private final transient IxMod active;
    private transient IxMod standBy;
    private transient boolean sequence = Boolean.TRUE;
    private transient BiFunction activeFn;
    private transient BiFunction standByFn;
    private transient BiFunction[] executors = new BiFunction[0];
    private transient BiFunction outputFn = null;
    private transient BiFunction nextFn = null;

    private IxPanel(IxWeb request) {
        this.active = request.active();
        this.standBy = request.standBy();
        this.outputFn = null;
        this.nextFn = (i, a) -> Ux.future((Object)a);
    }

    public static IxPanel on(IxWeb request) {
        return new IxPanel(request);
    }

    @SafeVarargs
    public final <T, O> IxPanel input(BiFunction<T, IxMod, Future<O>> ... executors) {
        this.executors = Objects.isNull(executors) ? new BiFunction[0] : executors;
        return this;
    }

    public <A, S, O> IxPanel output(BiFunction<A, S, Future<O>> outputFn) {
        this.outputFn = outputFn;
        return this;
    }

    public <I, A, O> IxPanel next(Function<IxMod, BiFunction<I, A, Future<O>>> nextFn) {
        this.nextFn = nextFn.apply(this.active);
        return this;
    }

    public <I, O> IxPanel parallel(BiFunction<I, IxMod, Future<O>> activeFn, BiFunction<I, IxMod, Future<O>> standFn) {
        this.sequence = false;
        this.activeFn = activeFn;
        this.standByFn = standFn;
        return this;
    }

    public <I, O> IxPanel parallel(BiFunction<I, IxMod, Future<O>> activeAndStandFn) {
        this.sequence = false;
        this.activeFn = activeAndStandFn;
        this.standByFn = activeAndStandFn;
        return this;
    }

    public <I, O> IxPanel passion(BiFunction<I, IxMod, Future<O>> activeFn, BiFunction<I, IxMod, Future<O>> standFn) {
        this.sequence = true;
        this.activeFn = activeFn;
        this.standByFn = standFn;
        return this;
    }

    public <I, O> IxPanel passion(BiFunction<I, IxMod, Future<O>> activeAndStandFn) {
        this.sequence = true;
        this.activeFn = activeAndStandFn;
        this.standByFn = activeAndStandFn;
        return this;
    }

    public <A, S, O> Future<O> runJ(JsonObject input) {
        JsonObject sure = Ut.valueJObject((JsonObject)input);
        return this.runInternal(sure.copy(), this.outputFn);
    }

    public <A, S, O> Future<O> runA(JsonArray input) {
        JsonArray sure = Ut.valueJArray((JsonArray)input);
        return this.runInternal(sure.copy(), this.outputFn);
    }

    private <I, A, S, O> Future<O> runInternal(I input, BiFunction<A, S, Future<O>> outputFn) {
        Function<Object, Future> activeFn = inputActive -> this.active.ready(inputActive, this.executors).compose(normalized -> this.activeFn.apply(normalized, this.active));
        Function<Object, Future> standFn = Objects.isNull(this.standByFn) || Objects.isNull(this.standBy) ? inputStand -> Ux.future((Object)inputStand) : inputStand -> this.standBy.ready(inputStand, this.executors).compose(normalized -> (Future)this.standByFn.apply(normalized, this.standBy));
        if (this.sequence) {
            Future activeFuture = activeFn.apply(input).compose(a -> (Future)this.nextFn.apply(input, a));
            return activeFuture.compose(a -> ((Future)standFn.apply(a)).compose(s -> {
                if (Objects.nonNull(outputFn)) {
                    return (Future)outputFn.apply(a, s);
                }
                return Ux.future((Object)s);
            }));
        }
        return CompositeFuture.join((Future)activeFn.apply(input), (Future)standFn.apply(input)).compose(composite -> {
            List result = composite.list();
            Object firstR = result.get(0);
            Object secondR = result.get(1);
            return (Future)outputFn.apply(firstR, secondR);
        }).otherwise(Ux.otherwise(() -> null));
    }
}

