/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.desk;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.cv.em.ApiSpec;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.commune.Envelop;
import io.vertx.up.unity.Ux;
import java.util.Objects;

public class IxWeb {
    private static final String LOGGER_MOD = "active=\u001b[1;36m{0}\u001b[m, standby=\u001b[1;95m{1}\u001b[m, api={2}, view={3}";
    private final transient ApiSpec apiSpecification;
    private transient IxMod active;
    private transient IxMod standBy;
    private transient Vis view;
    private transient String key;
    private transient String actor;
    private transient JsonObject bodyJ;
    private transient JsonArray bodyA;

    private IxWeb(ApiSpec spec) {
        this.apiSpecification = spec;
    }

    public static IxWeb create(ApiSpec spec) {
        return new IxWeb(spec);
    }

    public IxWeb build(Envelop envelop) {
        String actor;
        this.actor = actor = Ux.getString((Envelop)envelop);
        this.active = IxMod.create(actor).bind(envelop);
        String module = null;
        if (ApiSpec.BODY_JSON == this.apiSpecification) {
            this.bodyJ = Ux.getJson1((Envelop)envelop);
            module = Ux.getString2((Envelop)envelop);
            this.view = Ux.getVis((Envelop)envelop, (int)3);
        } else if (ApiSpec.BODY_STRING == this.apiSpecification) {
            this.key = Ux.getString1((Envelop)envelop);
            module = Ux.getString2((Envelop)envelop);
        } else if (ApiSpec.BODY_ARRAY == this.apiSpecification) {
            this.bodyA = Ux.getArray1((Envelop)envelop);
            module = Ux.getString2((Envelop)envelop);
        } else if (ApiSpec.BODY_WITH_KEY == this.apiSpecification) {
            this.key = Ux.getString1((Envelop)envelop);
            this.bodyJ = Ux.getJson2((Envelop)envelop);
        } else if (ApiSpec.BODY_NONE == this.apiSpecification) {
            module = Ux.getString1((Envelop)envelop);
            this.view = Ux.getVis2((Envelop)envelop);
        }
        if (Objects.isNull(this.view)) {
            this.view = Vis.smart(null);
        }
        if (Objects.isNull(module)) {
            if (Objects.nonNull(this.bodyJ)) {
                this.standBy = this.active.connecting(this.bodyJ);
            } else if (Objects.nonNull(this.bodyA)) {
                this.standBy = this.active.connecting(this.bodyA);
            }
        } else {
            this.standBy = this.active.connecting(module);
        }
        Ix.LOG.Web.info(this.getClass(), LOGGER_MOD, new Object[]{this.active.module().identifier(), Objects.nonNull(this.standBy) ? this.standBy.module().identifier() : null, this.apiSpecification, this.view.view() + ":" + this.view.position()});
        return this;
    }

    public IxMod active() {
        return this.active;
    }

    public IxMod standBy() {
        return this.standBy;
    }

    public JsonObject dataK() {
        return new JsonObject().put("key", (Object)this.key);
    }

    public JsonObject dataKJ() {
        return this.bodyJ.copy().put("key", (Object)this.key);
    }

    public JsonObject dataF() {
        return new JsonObject().put("filename", (Object)this.key);
    }

    public JsonObject dataJ() {
        return this.bodyJ.copy();
    }

    public JsonObject dataV() {
        return new JsonObject().put("view", (Object)this.view);
    }

    public JsonArray dataA() {
        return this.bodyA;
    }
}

