/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.input;

import io.aeon.experiment.specification.KModule;
import io.horizon.atom.common.Kv;
import io.horizon.exception.web._500InternalServerException;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.tp.error._409ModuleConflictException;
import io.vertx.tp.error._409MultiModuleException;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ExcelPre
implements Pre {
    private final transient ExcelClient client;

    ExcelPre(ExcelClient client) {
        this.client = client;
    }

    @Override
    public Future<JsonArray> inJAAsync(JsonObject data, IxMod in) {
        String actual;
        String filename = data.getString("filename");
        File file = new File(filename);
        if (!file.exists() || Objects.isNull(this.client)) {
            return Ux.futureA();
        }
        Kv<String, Set<ExTable>> content = this.readFile(file);
        if (!content.valid()) {
            return Ux.futureA();
        }
        KModule module = in.module();
        String expected = module.getTable();
        Fn.out((!expected.equals(actual = (String)content.key()) ? 1 : 0) != 0, _409ModuleConflictException.class, (Object[])new Object[]{this.getClass(), actual, expected});
        return this.client.extractAsync((Set)content.value());
    }

    private Kv<String, Set<ExTable>> readFile(File file) {
        ConcurrentHashMap tableMap = new ConcurrentHashMap();
        Kv kv = Kv.create();
        try {
            FileInputStream stream = new FileInputStream(file);
            Set tables = this.client.ingest((InputStream)stream, true);
            tables.stream().filter(Objects::nonNull).filter(item -> Objects.nonNull(item.getName())).forEach(item -> {
                if (!tableMap.containsKey(item.getName())) {
                    tableMap.put(item.getName(), new HashSet());
                }
                ((Set)tableMap.get(item.getName())).add(item);
            });
            Fn.out((1 != tableMap.size() ? 1 : 0) != 0, _409MultiModuleException.class, (Object[])new Object[]{this.getClass(), tableMap.size()});
            String tableName = (String)tableMap.keySet().iterator().next();
            kv.set((Object)tableName, (Object)((Set)tableMap.get(tableName)));
            return kv;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new _500InternalServerException(this.getClass(), ex.getMessage());
        }
    }
}

