/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.input;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;

class RUkPre
implements Pre {
    RUkPre() {
    }

    @Override
    public Future<JsonObject> inJAsync(JsonObject data, IxMod in) {
        JsonArray unique = in.module().getField().getUnique();
        JsonObject filters = this.condition(data, unique);
        Ix.LOG.Filter.info(this.getClass(), "{0}", new Object[]{filters.encode()});
        return Ux.future((Object)filters);
    }

    private JsonObject condition(JsonObject data, JsonArray unique) {
        JsonObject filters = new JsonObject();
        if (1 == unique.size()) {
            JsonArray fields = unique.getJsonArray(0);
            Set fieldSet = Ut.toSet((JsonArray)fields);
            filters.mergeIn(this.condition(data, fieldSet));
        } else {
            filters.put("", (Object)Boolean.FALSE);
            Ut.itJArray((JsonArray)unique, JsonArray.class, (each, index) -> filters.put("$" + index, (Object)this.condition(data, Ut.toSet((JsonArray)each))));
        }
        return filters;
    }

    private JsonObject condition(JsonObject data, Set<String> fieldSet) {
        JsonObject filters = new JsonObject();
        filters.put("", (Object)Boolean.TRUE);
        fieldSet.forEach(field -> {
            Object value = data.getValue(field);
            filters.put(field, value);
        });
        return filters;
    }

    @Override
    public Future<JsonObject> inAJAsync(JsonArray array, IxMod in) {
        JsonArray unique = in.module().getField().getUnique();
        JsonObject filters = new JsonObject();
        Ut.itJArray((JsonArray)array, JsonObject.class, (data, index) -> {
            JsonObject cond = this.condition((JsonObject)data, unique);
            filters.put("$" + index, (Object)cond);
        });
        return Ux.future((Object)filters);
    }
}

