/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.input;

import io.aeon.experiment.specification.KField;
import io.aeon.experiment.specification.KModule;
import io.horizon.spi.environment.Indent;
import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.input.Pre;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import java.util.stream.Collectors;

class SerialPre
implements Pre {
    private static final Annal LOGGER = Annal.get(SerialPre.class);

    SerialPre() {
    }

    @Override
    public Future<JsonObject> inJAsync(JsonObject data, IxMod in) {
        String sigma = data.getString("sigma");
        if (Ut.isNil((String)sigma)) {
            return Ux.future((Object)data);
        }
        return this.run(data, in, numbers -> Ux.channelA(Indent.class, () -> Ux.future((Object)data), stub -> {
            Ke.LOG.Ke.info(LOGGER, "Table here {0}, Serial numbers {1}", new Object[]{in.module().getTable(), numbers.encode()});
            ConcurrentHashMap numberMap = new ConcurrentHashMap();
            numbers.fieldNames().stream().filter(numberField -> !data.containsKey(numberField)).filter(numberField -> Objects.nonNull(numbers.getString(numberField))).forEach(numberField -> {
                String code = numbers.getString(numberField);
                numberMap.put(numberField, stub.indent(code, sigma));
            });
            return Fn.combineM(numberMap).compose(generated -> {
                generated.forEach((arg_0, arg_1) -> ((JsonObject)data).put(arg_0, arg_1));
                return Ux.future((Object)data);
            });
        }));
    }

    @Override
    public Future<JsonArray> inAAsync(JsonArray data, IxMod in) {
        String sigma = Ut.valueString((JsonArray)data, (String)"sigma");
        if (Ut.isNil((String)sigma) || Ut.isNil((JsonArray)data)) {
            return Ux.future((Object)data);
        }
        return this.run(data, in, numbers -> Ux.channelA(Indent.class, () -> Ux.future((Object)data), stub -> {
            Ke.LOG.Ke.info(LOGGER, "Table here {0}, Size {1}, Serial numbers {2}", new Object[]{in.module().getTable(), data.size(), numbers.encode()});
            ConcurrentHashMap numberMap = new ConcurrentHashMap();
            numbers.fieldNames().stream().filter(numberField -> Objects.nonNull(numbers.getString(numberField))).forEach(numberField -> numberMap.put(numberField, this.runIndent(data, (String)numberField, size -> {
                String code = numbers.getString(numberField);
                return stub.indent(code, sigma, size.intValue());
            })));
            return Fn.combineM(numberMap).compose(generated -> {
                generated.forEach((numberField, numberQueue) -> this.runFill(data, (String)numberField, (Queue<String>)numberQueue));
                return Ux.future((Object)data);
            });
        }));
    }

    private void runFill(JsonArray source, String field, Queue<String> numberQueue) {
        if (numberQueue.isEmpty()) {
            return;
        }
        Ut.itJArray((JsonArray)source).forEach(json -> {
            if (!json.containsKey(field) && !numberQueue.isEmpty()) {
                json.put(field, numberQueue.poll());
            }
        });
    }

    private Future<Queue<String>> runIndent(JsonArray source, String field, Function<Integer, Future<Queue<String>>> generator) {
        Set valueSet = Ut.itJArray((JsonArray)source).filter(json -> !json.containsKey(field)).map(json -> json.getString(field)).filter(Objects::isNull).collect(Collectors.toSet());
        int size = valueSet.size();
        if (0 < size) {
            return generator.apply(size);
        }
        return Ux.future(new LinkedBlockingDeque());
    }

    private <T> Future<T> run(T data, IxMod in, Function<JsonObject, Future<T>> executor) {
        KModule module = in.module();
        KField field = module.getField();
        JsonObject numbers = field.getNumbers();
        if (Ut.isNil((JsonObject)numbers)) {
            return Ux.future(data);
        }
        return executor.apply(numbers);
    }
}

