/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.next;

import io.horizon.eon.em.web.HttpStatusCode;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxKit;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.next.Co;
import io.vertx.up.unity.Ux;

class NtJData
implements Co<JsonObject, JsonObject, JsonObject, JsonObject> {
    private final transient IxMod in;

    NtJData(IxMod in) {
        this.in = in;
    }

    @Override
    public Future<JsonObject> next(JsonObject input, JsonObject active) {
        if (this.in.canJoin()) {
            JsonObject dataSt = this.in.dataIn(input, active);
            String key = this.in.module().getField().getKey();
            dataSt.remove(key);
            Ix.LOG.Web.info(this.getClass(), "Data In: {0}", new Object[]{dataSt.encode()});
            return Ux.future((Object)dataSt);
        }
        return Ux.future((Object)active.copy());
    }

    @Override
    public Future<JsonObject> ok(JsonObject active, JsonObject standBy) {
        HttpStatusCode status = IxKit.getStatus(standBy);
        if (HttpStatusCode.NO_CONTENT == status) {
            return Ux.future((Object)active);
        }
        if (this.in.canJoin()) {
            JsonObject dataSt = this.in.dataOut(active, standBy);
            Ix.LOG.Web.info(this.getClass(), "Data Out: {0}", new Object[]{dataSt.encode()});
            return Ux.future((Object)dataSt);
        }
        return Ux.future((Object)active.copy());
    }
}

