/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.trans;

import io.aeon.experiment.specification.KModule;
import io.aeon.experiment.specification.KTransform;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.trans.Tran;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class MapTran
implements Tran {
    private final transient boolean isFrom;

    MapTran(boolean isFrom) {
        this.isFrom = isFrom;
    }

    @Override
    public Future<JsonArray> inAAsync(JsonArray data, IxMod in) {
        if (in.canTransform()) {
            Ut.itJArray((JsonArray)data).forEach(each -> {
                this.mapping((JsonObject)each, in.module());
                if (in.canJoin()) {
                    this.mapping((JsonObject)each, in.connect());
                }
            });
        }
        return Ux.future((Object)data);
    }

    private void mapping(JsonObject data, KModule module) {
        KTransform transform = module.getTransform();
        if (Objects.isNull(transform)) {
            return;
        }
        JsonObject mapping = transform.getMapping();
        if (Ut.isNil((JsonObject)mapping)) {
            return;
        }
        Ut.itJObject((JsonObject)mapping, (config, field) -> {
            if (data.containsKey(field)) {
                ConcurrentMap<String, String> map = this.mapping((JsonObject)config);
                String value = data.getString(field);
                String to = (String)map.get(value);
                data.put(field, (Object)to);
            }
        });
    }

    private ConcurrentMap<String, String> mapping(JsonObject config) {
        ConcurrentHashMap<String, String> vector = new ConcurrentHashMap<String, String>();
        Ut.itJObject((JsonObject)config, (value, key) -> {
            if (this.isFrom) {
                vector.put((String)value, (String)key);
            } else {
                vector.put((String)key, (String)value);
            }
        });
        return vector;
    }
}

