/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.crud.uca.trans;

import io.aeon.experiment.specification.KModule;
import io.aeon.experiment.specification.KTransform;
import io.aeon.experiment.specification.KTree;
import io.horizon.atom.common.Kv;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.crud.init.IxPin;
import io.vertx.tp.crud.refine.Ix;
import io.vertx.tp.crud.uca.desk.IxMod;
import io.vertx.tp.crud.uca.trans.Tran;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

class TreeTran
implements Tran {
    private final transient boolean isFrom;

    TreeTran(boolean isFrom) {
        this.isFrom = isFrom;
    }

    @Override
    public Future<JsonArray> inAAsync(JsonArray data, IxMod in) {
        if (in.canTransform()) {
            return this.tree(in, this.isFrom).apply(data).compose(map -> this.treeAsync(data, in, (ConcurrentMap<String, String>)map));
        }
        return Ux.future((Object)data);
    }

    private Function<JsonArray, Future<ConcurrentMap<String, String>>> tree(IxMod in, boolean from) {
        return data -> {
            Kv keyValue;
            JsonArray values;
            KModule module = in.module();
            KTransform transform = module.getTransform();
            KTree tree = transform.getTree();
            if (Objects.isNull(tree)) {
                return Ux.future(new ConcurrentHashMap());
            }
            if (from) {
                values = Ut.toJArray((Set)Ut.valueSetString((JsonArray)data, (String)tree.getField()));
                keyValue = Kv.create((Object)tree.getIn(), (Object)tree.getOut());
            } else {
                values = Ut.toJArray((Set)Ut.valueSetArray((JsonArray)data, (String)tree.getField()));
                keyValue = Kv.create((Object)tree.getOut(), (Object)tree.getIn());
            }
            return this.treeAsync(in, tree, values, (Kv<String, String>)keyValue).compose(map -> {
                ConcurrentMap<String, String> mapInput = this.tree((JsonArray)data, (Kv<String, String>)keyValue);
                mapInput.forEach((field, key) -> {
                    if (!map.containsKey(field)) {
                        map.put(field, key);
                    }
                });
                return Ux.future((Object)map);
            });
        };
    }

    private Future<ConcurrentMap<String, String>> treeAsync(IxMod in, KTree tree, JsonArray values, Kv<String, String> keyValue) {
        JsonObject criteria = tree.region(in.parameters());
        String keyField = (String)keyValue.key();
        criteria.put(keyField + ",i", (Object)values);
        criteria.put("", (Object)Boolean.TRUE);
        Ix.LOG.Web.info(this.getClass(), "Tree Transform Condition: {0}", new Object[]{criteria.encode()});
        UxJooq jooq = IxPin.jooq(in);
        return jooq.fetchJAsync(criteria).compose(source -> Ux.future(this.tree((JsonArray)source, keyValue)));
    }

    private ConcurrentMap<String, String> tree(JsonArray source, Kv<String, String> keyValue) {
        ConcurrentHashMap<String, String> data = new ConcurrentHashMap<String, String>();
        Ut.itJArray((JsonArray)source).forEach(record -> {
            String fromValue = record.getString((String)keyValue.key());
            String toValue = record.getString((String)keyValue.value());
            if (Objects.nonNull(fromValue) && Objects.nonNull(toValue)) {
                data.put(fromValue, toValue);
            }
        });
        return data;
    }

    private Future<JsonArray> treeAsync(JsonArray data, IxMod in, ConcurrentMap<String, String> map) {
        if (!map.isEmpty()) {
            KModule module = in.module();
            KTree tree = module.getTransform().getTree();
            String field = tree.getField();
            Ut.itJArray((JsonArray)data).forEach(record -> {
                if (record.containsKey(field)) {
                    String value = record.getString(field);
                    String to = (String)map.get(value);
                    record.put(field, (Object)to);
                }
            });
        }
        return Ux.future((Object)data);
    }
}

